/*
 * Decompiled with CFR 0.152.
 */
package io.rapidapp;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

class ApiKeyInterceptor
implements ClientInterceptor {
    private final String apiKey;

    public ApiKeyInterceptor(String apiKey) {
        this.apiKey = apiKey;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                headers.put(Metadata.Key.of((String)"x-api-key", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)ApiKeyInterceptor.this.apiKey);
                super.start(responseListener, headers);
            }
        };
    }
}

