/*
 * Decompiled with CFR 0.152.
 */
package io.rapidapp;

import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.rapidapp.ApiKeyInterceptor;
import io.rapidapp.postgres.PostgresOuterClass;
import io.rapidapp.postgres.PostgresServiceGrpc;
import io.rapidapp.site.Site;
import io.rapidapp.site.SiteServiceGrpc;

public class RapidappClient {
    public static String API_URL = "api.rapidapp.io";
    public static int API_PORT = 443;
    private final String apiKey;

    public RapidappClient(String apiKey) {
        this.apiKey = apiKey;
    }

    public Site.SiteResponse getSite() {
        ManagedChannel channel = ManagedChannelBuilder.forAddress((String)API_URL, (int)API_PORT).useTransportSecurity().intercept(new ClientInterceptor[]{new ApiKeyInterceptor(this.apiKey)}).build();
        SiteServiceGrpc.SiteServiceBlockingStub stub = SiteServiceGrpc.newBlockingStub((Channel)channel);
        return stub.get(Empty.newBuilder().build());
    }

    public PostgresOuterClass.PostgresList getPostgresDatabases() {
        ManagedChannel channel = ManagedChannelBuilder.forAddress((String)API_URL, (int)API_PORT).useTransportSecurity().intercept(new ClientInterceptor[]{new ApiKeyInterceptor(this.apiKey)}).build();
        PostgresServiceGrpc.PostgresServiceBlockingStub stub = PostgresServiceGrpc.newBlockingStub((Channel)channel);
        return stub.list(Empty.newBuilder().build());
    }

    public PostgresOuterClass.PostgresId createPostgresDatabase(String name) {
        ManagedChannel channel = ManagedChannelBuilder.forAddress((String)API_URL, (int)API_PORT).useTransportSecurity().intercept(new ClientInterceptor[]{new ApiKeyInterceptor(this.apiKey)}).build();
        PostgresServiceGrpc.PostgresServiceBlockingStub stub = PostgresServiceGrpc.newBlockingStub((Channel)channel);
        PostgresOuterClass.PostgresId postgresId = stub.create(PostgresOuterClass.CreateRequest.newBuilder().setName(name).build());
        return postgresId;
    }

    public PostgresOuterClass.Postgres getPostgresDatabase(String id) {
        ManagedChannel channel = ManagedChannelBuilder.forAddress((String)API_URL, (int)API_PORT).useTransportSecurity().intercept(new ClientInterceptor[]{new ApiKeyInterceptor(this.apiKey)}).build();
        PostgresServiceGrpc.PostgresServiceBlockingStub stub = PostgresServiceGrpc.newBlockingStub((Channel)channel);
        PostgresOuterClass.Postgres postgres = stub.get(PostgresOuterClass.GetRequest.newBuilder().setId(id).build());
        return postgres;
    }

    public void deletePostgresDatabase(String id) {
        ManagedChannel channel = ManagedChannelBuilder.forAddress((String)API_URL, (int)API_PORT).useTransportSecurity().intercept(new ClientInterceptor[]{new ApiKeyInterceptor(this.apiKey)}).build();
        PostgresServiceGrpc.PostgresServiceBlockingStub stub = PostgresServiceGrpc.newBlockingStub((Channel)channel);
        stub.delete(PostgresOuterClass.DeleteRequest.newBuilder().setId(id).build());
    }
}

