/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.dsl;

import io.simplesource.api.CommandError;
import io.simplesource.api.CommandHandler;
import io.simplesource.data.Result;
import java.util.HashMap;
import java.util.Map;

public final class CommandHandlerBuilder<K, C, E, A> {
    private final Map<Class<? extends C>, CommandHandler<K, ? extends C, E, A>> commandHandlers = new HashMap<Class<? extends C>, CommandHandler<K, ? extends C, E, A>>();

    public static <K, C, E, A> CommandHandlerBuilder<K, C, E, A> newBuilder() {
        return new CommandHandlerBuilder<K, C, E, A>();
    }

    private CommandHandlerBuilder() {
    }

    public <SC extends C> CommandHandlerBuilder<K, C, E, A> onCommand(Class<SC> specificCommandClass, CommandHandler<K, SC, E, A> ch) {
        this.commandHandlers.put(specificCommandClass, ch);
        return this;
    }

    private Map<Class<? extends C>, CommandHandler<K, ? extends C, E, A>> getCommandHandlers() {
        return new HashMap<Class<? extends C>, CommandHandler<K, ? extends C, E, A>>(this.commandHandlers);
    }

    public <SC extends C> CommandHandler<K, SC, E, A> build() {
        Map ch = this.getCommandHandlers();
        return (key, currentAggregate, command) -> {
            CommandHandler commandHandler = (CommandHandler)ch.get(command.getClass());
            if (commandHandler == null) {
                return Result.failure((Object)CommandError.of(CommandError.Reason.InvalidCommand, String.format("Unhandled command type: %s", command.getClass().getSimpleName())), (Object[])new CommandError[0]);
            }
            return commandHandler.interpretCommand(key, currentAggregate, command);
        };
    }
}

