/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.api;

import io.simplesource.api.CommandError;
import io.simplesource.api.CommandId;
import io.simplesource.data.FutureResult;
import io.simplesource.data.Sequence;
import java.time.Duration;

public interface CommandAPI<K, C> {
    public FutureResult<CommandError, CommandId> publishCommand(Request<K, C> var1);

    public FutureResult<CommandError, Sequence> queryCommandResult(CommandId var1, Duration var2);

    default public FutureResult<CommandError, Sequence> publishAndQueryCommand(Request<K, C> commandRequest, Duration timeout) {
        return this.publishCommand(commandRequest).flatMap(v -> this.queryCommandResult(((Request)commandRequest).commandId, timeout));
    }

    public static final class Request<K, C> {
        private final CommandId commandId;
        private final K key;
        private final Sequence readSequence;
        private final C command;

        public Request(CommandId commandId, K key, Sequence readSequence, C command) {
            this.commandId = commandId;
            this.key = key;
            this.readSequence = readSequence;
            this.command = command;
        }

        public CommandId commandId() {
            return this.commandId;
        }

        public K key() {
            return this.key;
        }

        public Sequence readSequence() {
            return this.readSequence;
        }

        public C command() {
            return this.command;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            CommandId this$commandId = this.commandId();
            CommandId other$commandId = other.commandId();
            if (this$commandId == null ? other$commandId != null : !((Object)this$commandId).equals(other$commandId)) {
                return false;
            }
            K this$key = this.key();
            K other$key = other.key();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Sequence this$readSequence = this.readSequence();
            Sequence other$readSequence = other.readSequence();
            if (this$readSequence == null ? other$readSequence != null : !this$readSequence.equals(other$readSequence)) {
                return false;
            }
            C this$command = this.command();
            C other$command = other.command();
            return !(this$command == null ? other$command != null : !this$command.equals(other$command));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CommandId $commandId = this.commandId();
            result = result * 59 + ($commandId == null ? 43 : ((Object)$commandId).hashCode());
            K $key = this.key();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            Sequence $readSequence = this.readSequence();
            result = result * 59 + ($readSequence == null ? 43 : $readSequence.hashCode());
            C $command = this.command();
            result = result * 59 + ($command == null ? 43 : $command.hashCode());
            return result;
        }

        public String toString() {
            return "CommandAPI.Request(commandId=" + this.commandId() + ", key=" + this.key() + ", readSequence=" + this.readSequence() + ", command=" + this.command() + ")";
        }
    }
}

