/*
 * Decompiled with CFR 0.152.
 */
package io.snice.codecs.codegen;

public interface ClassNameConverter {
    public static ClassNameConverter defaultConverter() {
        return new DefaultClassNameConverter();
    }

    public String convert(String var1);

    public static class DefaultClassNameConverter
    implements ClassNameConverter {
        @Override
        public String convert(String name) {
            String origName = name.toLowerCase();
            char[] className = new char[origName.length()];
            int index = 0;
            boolean toUpperCase = true;
            for (int i = 0; i < origName.length(); ++i) {
                char ch = origName.charAt(i);
                if (i == 0 && Character.isDigit(ch)) {
                    if (ch != '3') {
                        throw new IllegalArgumentException("A Java class name cannot start with a digit and I currently do not have a good translation for the digit " + ch + ". If you have one, please update the code in " + ClassNameConverter.class.getCanonicalName());
                    }
                    className[index++] = 84;
                    toUpperCase = false;
                    continue;
                }
                if (ch == '-' || ch == '_') {
                    toUpperCase = true;
                    continue;
                }
                className[index++] = toUpperCase ? Character.toUpperCase(ch) : ch;
                toUpperCase = false;
            }
            char[] result = new char[index];
            System.arraycopy(className, 0, result, 0, index);
            return new String(result);
        }
    }
}

