/*
 * Decompiled with CFR 0.152.
 */
package io.snice.codecs.codegen;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public interface ClassNameConverter {
    public static ClassNameConverter defaultConverter() {
        return new DefaultClassNameConverter();
    }

    public String convert(String var1);

    public List<String> convertPreserveAbbreviation(String var1);

    public String convertToEnum(String var1);

    public static class DefaultClassNameConverter
    implements ClassNameConverter {
        private final Map<String, String> exceptions = new HashMap<String, String>();

        private DefaultClassNameConverter() {
            this.exceptions.put("Recovery (Restart Counter)".toLowerCase(), "RECOVERY");
            this.exceptions.put("Rat Type".toLowerCase(), "RAT");
            this.exceptions.put("PDN Type".toLowerCase(), "PDN");
            this.exceptions.put("MM Context (GSM Key and Triplets)".toLowerCase(), "MM_CONTEXT_GSM_KEY_TRIPLETS");
            this.exceptions.put("MM Context (GSM Key and Triplets)".toLowerCase(), "MM_CONTEXT_GSM_KEY_TRIPLETS");
            this.exceptions.put("MM Context (UMTS Key, Used Cipher and Quintuplets)".toLowerCase(), "MM_CONTEXT_UMTS_KEY_USED_CIPHER_QUINTUPLETS");
            this.exceptions.put("MM Context (GSM Key,Used Cipher and Quintuplets)".toLowerCase(), "MM_CONTEXT_GSM_KEY_USED_CIPHER_QUINTUPLETS");
            this.exceptions.put("MM Context (UMTS Key and Quintuplets)".toLowerCase(), "MM_CONTEXT_UMTS_KEY_QUINTUPLETS");
            this.exceptions.put("MM Context (EPS Security Context,Quadruplets and Quintuplets)".toLowerCase(), "MM_CONTEXT_EPS_SECURITY_CONTEXT_QUADRUPLETS_QUINTUPLETS");
            this.exceptions.put("MM Context (UMTS Key, Quadruplets and Quintuplets)".toLowerCase(), "MM_CONTEXT_UMTS_KEY_QUADRUPLETS_QUINTUPLETS");
            this.exceptions.put("Special IE type for IE Type Extension".toLowerCase(), "EXTENSION");
            this.exceptions.put("Extended Protocol Configuration Options (ePCO)".toLowerCase(), "EPCO");
            this.exceptions.put("F-Container".toLowerCase(), "F_CONTAINER");
            this.exceptions.put("F-Cause".toLowerCase(), "F_CAUSE");
            this.exceptions.put("H(e)NB Information Reporting".toLowerCase(), "HENB_INFORMATION_REPORTING");
        }

        private Optional<String> hasManualOverride(String name) {
            return Optional.ofNullable(this.exceptions.get(name.toLowerCase()));
        }

        @Override
        public List<String> convertPreserveAbbreviation(String name) {
            Optional<String> exception = this.hasManualOverride(name);
            if (exception.isPresent()) {
                return List.of(exception.get());
            }
            String origName = name.replaceAll("2G/3G", "2G3G").replaceAll("QoS", "Qos");
            char[] className = new char[origName.length()];
            int index = 0;
            boolean toUpperCase = true;
            boolean inAbbreviation = false;
            Object abbreviation = "";
            for (int i = 0; i < origName.length(); ++i) {
                char ch = origName.charAt(i);
                if (i == 0 && Character.isDigit(ch)) {
                    if (ch != '3') {
                        throw new IllegalArgumentException("A Java class name cannot start with a digit and I currently do not have a good translation for the digit " + ch + ". If you have one, please update the code in " + ClassNameConverter.class.getCanonicalName());
                    }
                    className[index++] = 84;
                    toUpperCase = false;
                    continue;
                }
                if (ch == '-' || ch == '_' || ch == '/' || Character.isWhitespace(ch)) {
                    toUpperCase = true;
                    if (!inAbbreviation) continue;
                    abbreviation = (String)abbreviation + "_";
                    continue;
                }
                if (ch == '(') {
                    if (!((String)abbreviation).isEmpty()) {
                        throw new IllegalArgumentException("Detected two so-called abbreviations within the given name. I can only handle a single one");
                    }
                    inAbbreviation = true;
                    toUpperCase = false;
                    continue;
                }
                if (ch == ')') {
                    inAbbreviation = false;
                    continue;
                }
                if (inAbbreviation) {
                    abbreviation = (String)abbreviation + ch;
                } else {
                    className[index++] = toUpperCase ? Character.toUpperCase(ch) : Character.toLowerCase(ch);
                }
                toUpperCase = false;
            }
            char[] result = new char[index];
            System.arraycopy(className, 0, result, 0, index);
            String javaClassName = new String(result);
            if (((String)abbreviation).isEmpty()) {
                return List.of(this.patch(javaClassName));
            }
            String finalClassName = this.patch(javaClassName);
            String finalAbbreviation = this.enumToClassName(this.convertToEnum(this.patch((String)abbreviation)));
            return List.of(finalClassName, finalAbbreviation);
        }

        private String enumToClassName(String enumName) {
            return Arrays.stream(enumName.toLowerCase().split("_")).map(s -> Character.toUpperCase(s.charAt(0)) + s.substring(1)).collect(Collectors.joining());
        }

        private String patch(String name) {
            return name.replaceAll("FTEID", "F_TEID").replaceAll("PTMSI", "P_TMSI");
        }

        @Override
        public String convertToEnum(String name) {
            List<String> names = this.convertPreserveAbbreviation(name);
            if (names.size() == 1) {
                return this.patch(this.toEnumName(names.get(0)));
            }
            return this.patch(this.toEnumName(names.get(1)));
        }

        private String toEnumName(String name) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < name.length() - 1; ++i) {
                char ch = name.charAt(i);
                char peek = name.charAt(i + 1);
                sb.append(Character.toUpperCase(ch));
                if (!Character.isLowerCase(ch) || !Character.isUpperCase(peek)) continue;
                sb.append("_");
            }
            sb.append(Character.toUpperCase(name.charAt(name.length() - 1)));
            return sb.toString();
        }

        @Override
        public String convert(String name) {
            return this.convertPreserveAbbreviation(name).get(0);
        }
    }
}

