/*
 * Decompiled with CFR 0.152.
 */
package io.snice.codecs.codegen;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;

public class FileSystemUtils {
    public static URL getURL(String file) throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource(file);
        FileSystemUtils.ensureFileSystem(url.toURI());
        return url;
    }

    public static void prepareOutputDirectory(File outputDirectory) {
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        if (!outputDirectory.exists()) {
            throw new IllegalArgumentException("The given output directory " + outputDirectory + " is not valid. Cannot generate the sources here");
        }
    }

    public static FileSystem ensureFileSystem(URI uri) {
        try {
            if ("jar".equals(uri.getScheme())) {
                HashMap<String, String> env = new HashMap<String, String>();
                env.put("create", "true");
                return FileSystems.newFileSystem(uri, env);
            }
        }
        catch (IOException | FileSystemAlreadyExistsException exception) {
            // empty catch block
        }
        return FileSystems.getDefault();
    }

    public static void save(Path outpuDirectory, String javaPackageName, String javaName, String content) {
        Path packageDir = outpuDirectory.resolve(javaPackageName.replaceAll("\\.", File.separator));
        Path fullFileName = packageDir.resolve(javaName + ".java");
        try {
            Files.createDirectories(packageDir, new FileAttribute[0]);
            Files.write(fullFileName, content.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to save " + fullFileName + " to " + packageDir, e);
        }
    }
}

