/*
 * Decompiled with CFR 0.152.
 */
package io.snice.codecs.codegen.diameter;

import io.snice.codecs.codegen.diameter.DiameterCollector;
import io.snice.codecs.codegen.diameter.DiameterRootBuilder;
import io.snice.codecs.codegen.diameter.builders.AttributeContext;
import io.snice.codecs.codegen.diameter.builders.DiameterSaxBuilder;
import io.snice.codecs.codegen.diameter.primitives.ApplicationPrimitive;
import io.snice.codecs.codegen.diameter.primitives.AvpPrimitive;
import io.snice.codecs.codegen.diameter.primitives.EnumPrimitive;
import io.snice.codecs.codegen.diameter.primitives.GavpPrimitive;
import io.snice.codecs.codegen.diameter.primitives.GroupedPrimitive;
import io.snice.codecs.codegen.diameter.primitives.TypePrimitive;
import io.snice.codecs.codegen.diameter.primitives.TypedefPrimitive;
import io.snice.codecs.codegen.diameter.primitives.UnknownPrimitive;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Function;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WiresharkDictionaryReader {
    private final SAXParserFactory saxFactory = SAXParserFactory.newInstance();
    private final SAXParser saxParser;
    private final WiresharkXmlHandler handler;

    public WiresharkDictionaryReader(DiameterCollector collector) throws Exception {
        this.saxFactory.setValidating(true);
        this.saxParser = this.saxFactory.newSAXParser();
        this.handler = new WiresharkXmlHandler(collector);
    }

    public void parse(String file) throws IOException, SAXException {
        this.saxParser.parse(new File(file), (DefaultHandler)this.handler);
    }

    public void parse(Path path) throws IOException, SAXException {
        this.saxParser.parse(path.toFile(), (DefaultHandler)this.handler);
    }

    public void parse(InputStream stream) throws IOException, SAXException {
        this.saxParser.parse(stream, (DefaultHandler)this.handler);
    }

    private static class WiresharkXmlHandler
    extends DefaultHandler {
        private final Stack<DiameterSaxBuilder> builders = new Stack();
        private final List<String> ignore = new ArrayList<String>();
        private final Map<String, Function<AttributeContext, DiameterSaxBuilder>> creators = new HashMap<String, Function<AttributeContext, DiameterSaxBuilder>>();
        private final Function<AttributeContext, DiameterSaxBuilder> defaultBuilder = UnknownPrimitive::of;
        private Locator locator;
        private final DiameterCollector collector;

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public WiresharkXmlHandler(DiameterCollector collector) {
            this.collector = collector;
            this.creators.put("application", ApplicationPrimitive::of);
            this.creators.put("avp", AvpPrimitive::of);
            this.creators.put("type", TypePrimitive::of);
            this.creators.put("typedefn", TypedefPrimitive::of);
            this.creators.put("enum", EnumPrimitive::of);
            this.creators.put("grouped", GroupedPrimitive::of);
            this.creators.put("gavp", GavpPrimitive::of);
            this.ignore.add("dictionary");
            this.ignore.add("base");
        }

        @Override
        public void startDocument() throws SAXException {
            AttributeContext empty = new AttributeContext("root", this.locator, null);
            this.builders.push(new DiameterRootBuilder(empty));
        }

        @Override
        public void endDocument() throws SAXException {
            DiameterSaxBuilder root = this.builders.pop();
            if (!this.builders.isEmpty()) {
                throw new IllegalStateException("Seems like we didnt push/pop correctly");
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String element = qName.toLowerCase();
            if (this.ignore.contains(element)) {
                return;
            }
            AttributeContext ctx = new AttributeContext(element, this.locator, attributes);
            DiameterSaxBuilder builder = this.creators.getOrDefault(element, this.defaultBuilder).apply(ctx);
            this.builders.peek().attachChildBuilder(builder);
            this.builders.push(builder);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.builders.peek().characters(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String element = qName.toLowerCase();
            if (this.ignore.contains(element)) {
                return;
            }
            this.builders.pop().build(this.collector);
        }
    }
}

