/*
 * Decompiled with CFR 0.152.
 */
package io.snice.codecs.codegen.diameter.builders;

import io.snice.codecs.codegen.diameter.CodeGenParseException;
import io.snice.preconditions.PreConditions;
import java.util.Optional;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class AttributeContext {
    private static final String ERROR_MSG = "Element doesn't contain the %s attribute";
    private final String elementName;
    private final Locator locator;
    private final Attributes attributes;

    public AttributeContext(String elementName, Locator locator, Attributes attributes) {
        this.elementName = elementName;
        this.locator = locator;
        this.attributes = attributes;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public String getElementName() {
        return this.elementName;
    }

    public long getLong(String name) throws CodeGenParseException {
        String value = this.getString(name);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            String msg = String.format("Unable to ensure attribute value '%s' as long for attribute '%s'", value, name);
            throw new CodeGenParseException(this.locator, msg);
        }
    }

    public int getInt(String name) throws CodeGenParseException {
        String value = this.getString(name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            String msg = String.format("Unable to ensure attribute value '%s' as int for attribute '%s'", value, name);
            throw new CodeGenParseException(this.locator, msg);
        }
    }

    public String getString(String name) throws CodeGenParseException {
        int index = this.attributes.getIndex(name);
        AttributeContext.assertArgument(index > -1, String.format(ERROR_MSG, name), this.locator);
        return this.attributes.getValue(index);
    }

    public Optional<String> getOptionalString(String name) throws CodeGenParseException {
        int index = this.attributes.getIndex(name);
        if (index == -1) {
            return Optional.empty();
        }
        String value = this.attributes.getValue(index);
        if ("none".equalsIgnoreCase(value) || PreConditions.checkIfEmpty((String)value)) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public void ensureElementName(String expectedName) {
        if (!expectedName.equals(this.elementName)) {
            throw new CodeGenParseException(this.locator, String.format("Unable to handle element '%s', I only handle elements named '%s'", this.elementName, expectedName));
        }
    }

    public static void assertArgument(boolean expression, String msg, Locator locator) throws CodeGenParseException {
        if (!expression) {
            throw new CodeGenParseException(locator, msg);
        }
    }
}

