/*
 * Decompiled with CFR 0.152.
 */
package io.snice.codecs.codegen.diameter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.snice.codecs.codec.diameter.avp.Vendor;
import io.snice.codecs.codegen.ClassNameConverter;
import io.snice.codecs.codegen.FileSystemUtils;
import io.snice.codecs.codegen.diameter.DiameterCollector;
import io.snice.codecs.codegen.diameter.Typedef;
import io.snice.codecs.codegen.diameter.WiresharkDictionaryReader;
import io.snice.codecs.codegen.diameter.config.Attributes;
import io.snice.codecs.codegen.diameter.config.CodeConfig2;
import io.snice.codecs.codegen.diameter.config.Settings;
import io.snice.codecs.codegen.diameter.primitives.AvpPrimitive;
import io.snice.codecs.codegen.diameter.primitives.EnumPrimitive;
import io.snice.codecs.codegen.diameter.templates.AvpFramerTemplate;
import io.snice.codecs.codegen.diameter.templates.AvpTemplate;
import io.snice.preconditions.PreConditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGen {
    private static final Logger logger = LoggerFactory.getLogger(CodeGen.class);
    public static final String DICTIONARY_DIR = "diameter";
    public static final String DICTIONARY_FILE_NAME = "dictionary.xml";
    private final CodeConfig2 config;
    private final Settings avpSettings;
    private final DiameterCollector collector = new DiameterCollector();

    public static CodeGen of(CodeConfig2 config) throws IllegalArgumentException {
        Path sourceRoot = config.getSourceRootDir().orElseThrow(() -> new IllegalArgumentException("You must specify the root directory to where all source code will be generated"));
        CodeConfig2 actualConfig = config.copy().withSourceRoot(sourceRoot).withWiresharkDictionaryXml(config.getDictionaryXml()).build();
        ClassNameConverter classNameConverter = ClassNameConverter.defaultConverter();
        Settings avp = new Settings("AVP", sourceRoot.toAbsolutePath(), classNameConverter, actualConfig.getPackageConfig().getAvpPackage(), actualConfig.getAvpPackageConfig().get());
        return new CodeGen(actualConfig, avp);
    }

    private CodeGen(CodeConfig2 config, Settings avpSettings) {
        this.config = config;
        this.avpSettings = avpSettings;
    }

    public void execute() {
        try {
            FileSystemUtils.ensureFileSystem((URI)this.config.getDictionaryXml());
            Path xml = Path.of(this.config.getDictionaryXml());
            InputStream xmlInputStream = Files.newInputStream(xml, new OpenOption[0]);
            WiresharkDictionaryReader reader = new WiresharkDictionaryReader(this.collector);
            reader.parse(xmlInputStream);
            List<Attributes> renderedAvps = this.renderAvps();
            this.renderAvpFramer(renderedAvps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<Attributes> renderAvps() throws IOException, URISyntaxException {
        List avps;
        Settings settings = this.avpSettings;
        if (settings.renderAll()) {
            logger.info("Rendering all found AVPs, minus the ones on the exclude list.");
            avps = this.collector.getAvps().stream().filter(avp -> !settings.isExcluded(avp.getName())).collect(Collectors.toList());
        } else {
            logger.info("Rendering only those AVPs explicitly listed on the \"include\" list");
            avps = this.collector.getAvps().stream().filter(avp -> settings.isIncluded(avp.getName())).collect(Collectors.toList());
        }
        ArrayList<Attributes> renderedAvps = new ArrayList<Attributes>();
        for (AvpPrimitive avp2 : avps) {
            AvpTemplate template = AvpTemplate.load(avp2);
            Attributes attributes = this.createAvpConfig(avp2);
            renderedAvps.add(attributes);
            String rendered = template.render(attributes.getAttributes());
            this.save(settings, attributes, rendered);
        }
        return renderedAvps;
    }

    private void renderAvpFramer(List<Attributes> avps) throws IOException, URISyntaxException {
        AvpFramerTemplate template = AvpFramerTemplate.load();
        Attributes framerAttributes = new Attributes("AvpFramer", "io.snice.codecs.codec.diameter.avp", Map.of());
        String rendered = template.render(framerAttributes, avps);
        this.save(this.avpSettings, framerAttributes, rendered);
    }

    public Attributes createAvpConfig(AvpPrimitive avp) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        HashMap<String, Object> javaAttributes = new HashMap<String, Object>();
        HashMap<String, String> javaClassAttributes = new HashMap<String, String>();
        HashMap<String, Object> avpAttributes = new HashMap<String, Object>();
        HashMap<String, String> avpTypeAttributes = new HashMap<String, String>();
        ArrayList<String> imports = new ArrayList<String>();
        attributes.put("avp", avpAttributes);
        attributes.put("java", javaAttributes);
        javaAttributes.put("imports", imports);
        javaAttributes.put("class", javaClassAttributes);
        avpAttributes.put("type", avpTypeAttributes);
        avpAttributes.put("tbcd_formatted", false);
        String className = this.avpSettings.convert(avp.getName());
        javaClassAttributes.put("name", className);
        javaAttributes.put("package", this.avpSettings.getPackageName());
        if ("Msisdn".equals(className)) {
            avpAttributes.put("tbcd_formatted", true);
        }
        avpAttributes.put("code", avp.getCode());
        avpAttributes.put("mandatory_bit", avp.getMandatoryBit().toString());
        avpAttributes.put("protected_bit", avp.getProtectedBit().toString());
        avpAttributes.put("vendor_bit", avp.getVendorBit().toString());
        avpAttributes.put("may_encrypt_bit", avp.getMayEncryptBit());
        avpAttributes.put("vendor", avp.getVendor().orElse(Vendor.NONE).toString());
        Typedef typedef = avp.getTypedef();
        String typeInterface = typedef.getImplementingInterface().orElseThrow(() -> new IllegalArgumentException("Unable to render AVP " + avp.getName() + " because missing interface definition for the type " + typedef.getName()));
        String typeInterfaceFqdn = typedef.getImplementingInterfaceFqdn().orElseThrow(IllegalAccessError::new);
        String typeClass = typedef.getImplementingClass().orElseThrow(IllegalArgumentException::new);
        String typeClassFqdn = typedef.getImplementingClassFqdn().orElseThrow(IllegalArgumentException::new);
        avpTypeAttributes.put("class", typeClass);
        avpTypeAttributes.put("interface", typeInterface);
        boolean appendEnumCode = List.of("ResultCode", "ExperimentalResultCode").stream().filter(className::equals).findFirst().isPresent();
        if (avp.isEnumerated()) {
            List<EnumPrimitive> enums = avp.toEnumerated().getSortedEnums();
            List enumList = enums.stream().map(e -> {
                String fullName = appendEnumCode ? e.getEnumName() + "_" + e.getEnumCode() : e.getEnumName();
                return fullName + "(\"" + e.getEnumName() + "\", " + e.getEnumCode() + ")";
            }).collect(Collectors.toList());
            avpAttributes.put("enum_definition", enumList);
            List staticVariables = enums.stream().map(e -> {
                String enumName = this.avpSettings.convert(e.getEnumName());
                String variableName = appendEnumCode ? enumName + e.getEnumCode() : enumName;
                return className + " " + variableName + " = " + className + ".of(" + e.getEnumCode() + ");";
            }).collect(Collectors.toList());
            avpAttributes.put("variable_definition", staticVariables);
            List enumSwitch = enums.stream().map(e -> {
                String fullName = appendEnumCode ? e.getEnumName() + "_" + e.getEnumCode() : e.getEnumName();
                return "case " + e.getEnumCode() + ": return Optional.of(" + fullName + ");";
            }).collect(Collectors.toList());
            avpAttributes.put("enum_switch", enumSwitch);
        }
        imports.add(typeClassFqdn);
        imports.add(typeInterfaceFqdn);
        return new Attributes(className, this.avpSettings.getPackageName(), attributes);
    }

    private void save(Settings settings, Attributes attributes, String content) throws IOException {
        Path src = settings.getJavaSrcDir();
        Path packageDir = src.resolve(attributes.getPackage().replaceAll("\\.", File.separator));
        Path fullFileName = packageDir.resolve(attributes.getName() + ".java");
        logger.debug("Saving {} as {}", (Object)attributes.getName(), (Object)fullFileName);
        Files.createDirectories(packageDir, new FileAttribute[0]);
        Files.write(fullFileName, content.getBytes(), new OpenOption[0]);
    }

    public static ArgumentParser configureParser(Path defaultConfig) {
        ArgumentParser parser = ArgumentParsers.newFor((String)"codegen").build();
        parser.description("Code generator for diameter");
        parser.addArgument(new String[]{"--config"}).help("The configuration file").setDefault((Object)defaultConfig.toAbsolutePath().toString()).metavar(new String[]{"<config>"});
        parser.addArgument(new String[]{"--source-dir"}).help("The directory to where the source code will be generated").setDefault((Object)".").metavar(new String[]{"<source-dir>"});
        return parser;
    }

    public static CodeConfig2 loadConfig(String config) throws IOException {
        Path path = Paths.get(config, new String[0]).toAbsolutePath();
        return CodeGen.loadConfig(path);
    }

    public static CodeConfig2 loadConfig(URI config) throws IOException {
        Path path = Paths.get(config).toAbsolutePath();
        return CodeGen.loadConfig(path);
    }

    public static CodeConfig2 loadConfig(Path path) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        PreConditions.assertArgument((boolean)Files.exists(path, new LinkOption[0]), (String)("The given config file does not exist (" + path + ")"));
        PreConditions.assertArgument((boolean)Files.isRegularFile(path, new LinkOption[0]), (String)("The given config file is not a regular file (" + path + ")"));
        return (CodeConfig2)mapper.readValue(path.toFile(), CodeConfig2.class);
    }

    public static CodeConfig2 loadConfig(InputStream stream) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (CodeConfig2)mapper.readValue(stream, CodeConfig2.class);
    }

    public static Path locateDefaultConfigFile() throws IllegalArgumentException {
        try {
            String defaultConfigFile = "codegen.yml";
            URL url = Thread.currentThread().getContextClassLoader().getResource("codegen.yml");
            if (url == null) {
                url = CodeGen.class.getResource("codegen.yml");
            }
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to locate the default configuration file for the code generation. Please specify a configuration file on the command line");
        }
    }

    public static Optional<CodeGen> parse(Path defaultCodeConfigFile, String ... args) {
        ArgumentParser parser = CodeGen.configureParser(defaultCodeConfigFile);
        try {
            Namespace result = parser.parseArgs(args);
            CodeConfig2 config = CodeGen.loadConfig(result.getString("config"));
            CodeConfig2.Builder confBuilder = config.copy();
            confBuilder.withSourceRoot(Paths.get(result.getString("source_dir"), new String[0]));
            return Optional.of(CodeGen.of(confBuilder.build()));
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
        }
        catch (IllegalArgumentException e) {
            logger.error("Illegal argument", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Unable to read/write from/to file", (Throwable)e);
        }
        return Optional.empty();
    }

    public static void main(String ... args) throws Exception {
        Path defaultCodeConfigFile = CodeGen.locateDefaultConfigFile();
        CodeGen.parse(defaultCodeConfigFile, args).ifPresent(CodeGen::execute);
    }
}

