/*
 * Decompiled with CFR 0.152.
 */
package io.snice.codecs.codegen.diameter.builders;

import io.snice.codecs.codegen.diameter.CodeGenParseException;
import io.snice.codecs.codegen.diameter.DiameterCollector;
import io.snice.codecs.codegen.diameter.Typedef;
import io.snice.codecs.codegen.diameter.builders.AttributeContext;
import io.snice.codecs.codegen.diameter.primitives.DiameterPrimitive;
import io.snice.codecs.codegen.diameter.primitives.EnumPrimitive;
import io.snice.codecs.codegen.diameter.primitives.GavpPrimitive;
import io.snice.codecs.codegen.diameter.primitives.GroupedPrimitive;
import io.snice.codecs.codegen.diameter.primitives.TypePrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.xml.sax.SAXException;

public interface DiameterSaxBuilder<T extends DiameterPrimitive> {
    public void characters(char[] var1, int var2, int var3) throws SAXException;

    public void attachChildBuilder(DiameterSaxBuilder<T> var1) throws CodeGenParseException;

    public String getElementName();

    default public boolean isAvp() {
        return "avp".equals(this.getElementName());
    }

    default public boolean isApplication() {
        return "application".equals(this.getElementName());
    }

    default public boolean isType() {
        return "type".equals(this.getElementName());
    }

    default public boolean isUnknown() {
        return false;
    }

    public T build(DiameterCollector var1);

    public static abstract class BaseBuilder<T extends DiameterPrimitive>
    implements DiameterSaxBuilder<T> {
        private final AttributeContext ctx;
        private final Map<String, List<DiameterSaxBuilder>> children = new HashMap<String, List<DiameterSaxBuilder>>();

        protected BaseBuilder(AttributeContext ctx) {
            this.ctx = ctx;
        }

        protected List<String> getKnownChildElements() {
            return null;
        }

        protected CodeGenParseException createException(String msg) {
            return new CodeGenParseException(this.ctx.getLocator(), msg);
        }

        protected Map<String, List<DiameterPrimitive>> buildChildren(DiameterCollector ctx) {
            HashMap<String, List<DiameterPrimitive>> builtChildren = new HashMap<String, List<DiameterPrimitive>>();
            this.children.entrySet().forEach(entry -> builtChildren.put((String)entry.getKey(), ((List)entry.getValue()).stream().map(b -> b.build(ctx)).collect(Collectors.toList())));
            return builtChildren;
        }

        protected boolean acceptChild(DiameterSaxBuilder child) throws CodeGenParseException {
            if (this.getKnownChildElements() == null || this.getKnownChildElements().contains(child.getElementName())) {
                return true;
            }
            throw this.createException("Un-acceptable child element '" + child.getElementName() + "'. Please either fix the XML file or add missing code to accept this child element");
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            char[] que = new char[length];
            System.arraycopy(ch, start, que, 0, length);
            System.err.println("-->" + new String(que) + "<---");
            throw new CodeGenParseException(this.ctx.getLocator(), "Did not expect to get any additional characters");
        }

        @Override
        public void attachChildBuilder(DiameterSaxBuilder child) throws CodeGenParseException {
            if (this.acceptChild(child)) {
                this.children.computeIfAbsent(child.getElementName(), key -> new ArrayList()).add(child);
            }
        }

        protected boolean isNotEmpty(List list) {
            return list != null && !list.isEmpty();
        }

        protected List<GavpPrimitive> getGavps(Map<String, List<DiameterPrimitive>> map) {
            return map.getOrDefault("gavp", Collections.emptyList()).stream().map(DiameterPrimitive::toGavpPrimitive).collect(Collectors.toList());
        }

        protected List<TypePrimitive> getTypes(Map<String, List<DiameterPrimitive>> map) {
            return map.getOrDefault("type", Collections.emptyList()).stream().map(DiameterPrimitive::toTypePrimitive).collect(Collectors.toList());
        }

        protected Optional<Typedef> getType(Map<String, List<DiameterPrimitive>> map) {
            List<TypePrimitive> types = this.getTypes(map);
            if (types.size() > 1) {
                throw this.createException("There can only be one type element");
            }
            return types.isEmpty() ? Optional.empty() : Optional.of(types.get(0).getTypedef());
        }

        protected List<GroupedPrimitive> getGroupeds(Map<String, List<DiameterPrimitive>> map) {
            return map.getOrDefault("grouped", Collections.emptyList()).stream().map(DiameterPrimitive::toGroupedPrimitive).collect(Collectors.toList());
        }

        protected Optional<GroupedPrimitive> getGrouped(Map<String, List<DiameterPrimitive>> map) {
            List<GroupedPrimitive> groups = this.getGroupeds(map);
            if (groups.size() > 1) {
                throw this.createException("There can only be one grouped element");
            }
            return groups.isEmpty() ? Optional.empty() : Optional.of(groups.get(0));
        }

        protected List<EnumPrimitive> getEnums(Map<String, List<DiameterPrimitive>> map) {
            return map.getOrDefault("enum", Collections.emptyList()).stream().map(DiameterPrimitive::toEnumPrimitive).collect(Collectors.toList());
        }
    }
}

