/*
 * Decompiled with CFR 0.152.
 */
package io.snice.codecs.codegen.diameter.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.snice.codecs.codegen.ClassNameConverter;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
public class CodeConfig2 {
    private static final Logger logger = LoggerFactory.getLogger(CodeConfig2.class);
    private final PackageConfig packageConfig;
    private final Optional<Path> sourceRoot;
    private final URI dictionaryXml;
    private final Optional<GenerationConfig> avpPackageConfig;
    private final Optional<GenerationConfig> cmdPackageConfig;
    private final Optional<GenerationConfig> appPackageConfig;

    public static Builder of() {
        return new Builder();
    }

    private CodeConfig2(PackageConfig packageConfig, URI dictionaryXml, Optional<Path> sourceRoot, Optional<GenerationConfig> avpPackageConfig, Optional<GenerationConfig> cmdPackageConfig, Optional<GenerationConfig> appPackageConfig) {
        this.packageConfig = packageConfig;
        this.dictionaryXml = dictionaryXml;
        this.sourceRoot = sourceRoot;
        this.avpPackageConfig = avpPackageConfig;
        this.cmdPackageConfig = cmdPackageConfig;
        this.appPackageConfig = appPackageConfig;
    }

    public URI getDictionaryXml() {
        return this.dictionaryXml;
    }

    public Optional<GenerationConfig> getAvpPackageConfig() {
        return this.avpPackageConfig;
    }

    public Optional<GenerationConfig> getCmdPackageConfig() {
        return this.cmdPackageConfig;
    }

    public Optional<GenerationConfig> getAppPackageConfig() {
        return this.appPackageConfig;
    }

    public Optional<Path> getSourceRootDir() {
        return this.sourceRoot;
    }

    public PackageConfig getPackageConfig() {
        return this.packageConfig;
    }

    public Builder copy() {
        Builder builder = new Builder();
        builder.withWiresharkDictionaryXml(this.dictionaryXml);
        this.sourceRoot.ifPresent(builder::withSourceRoot);
        this.appPackageConfig.ifPresent(builder::withAppGenerationConfig);
        this.cmdPackageConfig.ifPresent(builder::withCmdGenerationConfig);
        this.avpPackageConfig.ifPresent(builder::withAvpGenerationConfig);
        builder.withPackageConfig(this.packageConfig);
        return builder;
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="with")
    public static class Builder {
        private static final String CODE_GEN_MVN_DIR = "codec-diameter-codegen";
        private static final String DEFAULT_BASE_PACKAGE = "io.pkts.diameter";
        private static final String DEFAULT_AVP_PACKAGE = "avp.api";
        private static final String DEFAULT_CMD_PACKAGE = "cmd";
        private static final String DEFAULT_APP_PACKAGE = "app";
        private final ClassNameConverter classNameConverter = ClassNameConverter.defaultConverter();
        private Path sourceRoot;
        private URI dictionaryXml;
        private URI dictionaryDtd;
        private final Map<String, Path> subdirs = new HashMap<String, Path>();
        private PackageConfig packageConfig = new PackageConfig("io.pkts.diameter", "avp.api", "cmd", "app");
        private Optional<GenerationConfig> avpGenerationConfig = Optional.empty();
        private Optional<GenerationConfig> cmdGenerationConfig = Optional.empty();
        private Optional<GenerationConfig> appGenerationConfig = Optional.empty();

        private Builder() {
        }

        @JsonProperty(value="sourceRoot")
        public Builder withSourceRoot(Path root) {
            this.sourceRoot = root;
            return this;
        }

        @JsonProperty(value="package")
        public Builder withPackageConfig(PackageConfig config) {
            this.packageConfig = config;
            return this;
        }

        public Builder withWiresharkDictionaryXml(URI xml) {
            this.dictionaryXml = xml;
            return this;
        }

        @JsonProperty(value="avp")
        public Builder withAvpGenerationConfig(GenerationConfig config) {
            this.avpGenerationConfig = Optional.ofNullable(config);
            return this;
        }

        @JsonProperty(value="cmd")
        public Builder withCmdGenerationConfig(GenerationConfig config) {
            this.cmdGenerationConfig = Optional.ofNullable(config);
            return this;
        }

        @JsonProperty(value="app")
        public Builder withAppGenerationConfig(GenerationConfig config) {
            this.appGenerationConfig = Optional.ofNullable(config);
            return this;
        }

        public CodeConfig2 build() {
            return new CodeConfig2(this.packageConfig, this.dictionaryXml, Optional.ofNullable(this.sourceRoot), this.avpGenerationConfig, this.cmdGenerationConfig, this.appGenerationConfig);
        }
    }

    public static class PackageConfig {
        private final String main;
        private final String avp;
        private final String cmd;
        private final String app;

        @JsonCreator
        public PackageConfig(@JsonProperty(value="main") String main, @JsonProperty(value="avp") String avp, @JsonProperty(value="cmd") String cmd, @JsonProperty(value="app") String app) {
            this.main = main;
            this.avp = PackageConfig.append(main, avp);
            this.cmd = PackageConfig.append(main, cmd);
            this.app = PackageConfig.append(main, app);
        }

        public String getAvpPackage() {
            return this.avp;
        }

        public String getCmdPackage() {
            return this.cmd;
        }

        public String getAppPackage() {
            return this.app;
        }

        private static String append(String root, String sub) {
            String parent = root.endsWith(".") ? root.substring(0, root.length() - 1) : root;
            return sub.startsWith(".") ? parent + sub : parent + "." + sub;
        }
    }

    public static class GenerationConfig {
        private final List<String> include;
        private final List<String> exclude;

        @JsonCreator
        public GenerationConfig() {
            this(null, null);
        }

        @JsonCreator
        public GenerationConfig(@JsonProperty(value="include") List<String> include, @JsonProperty(value="exclude") List<String> exclude) {
            this.include = include != null ? include : Collections.emptyList();
            this.exclude = exclude != null ? exclude : Collections.emptyList();
        }

        public boolean generateAll() {
            return this.include.isEmpty();
        }

        public boolean isExcluded(String name) {
            return this.exclude.contains(name);
        }

        public boolean isIncluded(String name) {
            return this.include.contains(name);
        }
    }
}

