/*
 * Decompiled with CFR 0.152.
 */
package io.snice.codecs.codegen.diameter.primitives;

import io.snice.codecs.codegen.diameter.CodeGenParseException;
import io.snice.codecs.codegen.diameter.DiameterCollector;
import io.snice.codecs.codegen.diameter.builders.AttributeContext;
import io.snice.codecs.codegen.diameter.builders.DiameterSaxBuilder;
import io.snice.codecs.codegen.diameter.primitives.DiameterPrimitive;
import java.util.Optional;

public interface ApplicationPrimitive
extends DiameterPrimitive {
    public static final String NAME = "application";

    @Override
    default public String getElementName() {
        return NAME;
    }

    public static Builder of(AttributeContext ctx) throws CodeGenParseException {
        ctx.ensureElementName(NAME);
        long appId = ctx.getLong("id");
        String name = ctx.getString("name");
        Optional<String> uri = ctx.getOptionalString("uri");
        return new Builder(ctx, appId, name, uri);
    }

    public static class Builder
    extends DiameterSaxBuilder.BaseBuilder<ApplicationPrimitive> {
        private final long appId;
        private final String name;
        private final Optional<String> uri;

        private Builder(AttributeContext ctx, long appId, String name, Optional<String> uri) {
            super(ctx);
            this.appId = appId;
            this.name = name;
            this.uri = uri;
        }

        @Override
        public String getElementName() {
            return ApplicationPrimitive.NAME;
        }

        @Override
        public ApplicationPrimitive build(DiameterCollector ctx) {
            return null;
        }
    }
}

