/*
 * Decompiled with CFR 0.152.
 */
package io.snice.codecs.codegen.diameter.primitives;

import io.snice.codecs.codec.diameter.avp.AvpMandatory;
import io.snice.codecs.codec.diameter.avp.AvpProtected;
import io.snice.codecs.codec.diameter.avp.AvpVendor;
import io.snice.codecs.codec.diameter.avp.Vendor;
import io.snice.codecs.codegen.diameter.CodeGenParseException;
import io.snice.codecs.codegen.diameter.DiameterCollector;
import io.snice.codecs.codegen.diameter.Typedef;
import io.snice.codecs.codegen.diameter.builders.AttributeContext;
import io.snice.codecs.codegen.diameter.builders.DiameterSaxBuilder;
import io.snice.codecs.codegen.diameter.primitives.DiameterPrimitive;
import io.snice.codecs.codegen.diameter.primitives.EnumPrimitive;
import io.snice.codecs.codegen.diameter.primitives.GroupedPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public interface AvpPrimitive
extends DiameterPrimitive {
    public static final String NAME = "avp";

    @Override
    default public String getElementName() {
        return NAME;
    }

    @Override
    default public AvpPrimitive toAvpPrimitive() throws ClassCastException {
        return this;
    }

    default public boolean isGrouped() {
        return false;
    }

    default public GroupedAvpPrimitive toGrouped() throws ClassCastException {
        throw new ClassCastException("Unable to cast a " + this.getClass().getName() + " into a " + GroupedAvpPrimitive.class.getName());
    }

    default public boolean isTyped() {
        return false;
    }

    default public TypedAvpPrimitive toTyped() throws ClassCastException {
        throw new ClassCastException("Unable to cast a " + this.getClass().getName() + " into a " + TypedAvpPrimitive.class.getName());
    }

    default public boolean isEnumerated() {
        return false;
    }

    default public EnumeratedAvpPrimitive toEnumerated() throws ClassCastException {
        throw new ClassCastException("Unable to cast a " + this.getClass().getName() + " into a " + EnumeratedAvpPrimitive.class.getName());
    }

    public String getName();

    public long getCode();

    public AvpMandatory getMandatoryBit();

    public AvpVendor getVendorBit();

    public AvpProtected getProtectedBit();

    public boolean getMayEncryptBit();

    public Optional<Vendor> getVendor();

    public static Builder of(AttributeContext ctx) throws CodeGenParseException {
        ctx.ensureElementName(NAME);
        String name = ctx.getString("name");
        long code = ctx.getLong("code");
        AvpMandatory mandatoryBit = (AvpMandatory)AvpPrimitive.map(ctx, name, "mandatory", v -> AvpMandatory.getValue((String)v));
        AvpProtected protectedBit = (AvpProtected)AvpPrimitive.map(ctx, name, "protected", v -> AvpProtected.getValue((String)v));
        AvpVendor vendorBit = (AvpVendor)AvpPrimitive.map(ctx, name, "vendor-bit", v -> AvpVendor.getValue((String)v));
        boolean mayEncrypt = AvpPrimitive.mapYesNo(name, ctx.getString("may-encrypt"));
        Optional<Vendor> vendor = AvpPrimitive.mapVendor(ctx);
        return new Builder(ctx, name, code, mandatoryBit, protectedBit, vendorBit, mayEncrypt, vendor);
    }

    private static Optional<Vendor> mapVendor(AttributeContext ctx) {
        Optional<String> value = ctx.getOptionalString("vendor-id");
        return value.flatMap(Vendor::getValue);
    }

    private static boolean mapYesNo(String avp, String value) {
        if ("yes".equalsIgnoreCase(value)) {
            return true;
        }
        if ("no".equalsIgnoreCase(value)) {
            return false;
        }
        throw new IllegalArgumentException("Unable to map the value " + value + " to a boolean for AVP " + avp);
    }

    private static <T> T map(AttributeContext ctx, String name, String key, Function<String, Optional<T>> fn) {
        String value = ctx.getString(key);
        return fn.apply(value).orElseThrow(() -> new IllegalArgumentException("Unable to map the " + key + " field for AVP " + name + ". Value was " + value));
    }

    public static class EnumeratedAvpPrimitive
    extends BaseAvpPrimitive {
        final List<EnumPrimitive> enums;

        @Override
        public boolean isEnumerated() {
            return true;
        }

        @Override
        public EnumeratedAvpPrimitive toEnumerated() throws ClassCastException {
            return this;
        }

        public List<EnumPrimitive> getSortedEnums() {
            this.enums.sort((o1, o2) -> {
                long res = o1.getEnumCode() - o2.getEnumCode();
                if (res < 0L) {
                    return -1;
                }
                if (res == 0L) {
                    return 0;
                }
                return 1;
            });
            return this.enums;
        }

        private EnumeratedAvpPrimitive(String name, long code, List<EnumPrimitive> enums, AvpMandatory mandatoryBit, AvpProtected protectedBit, AvpVendor vendorBit, boolean mayEncrypt, Optional<Vendor> vendor) {
            super(name, code, mandatoryBit, protectedBit, vendorBit, mayEncrypt, vendor);
            this.enums = enums;
        }

        @Override
        public Typedef getTypedef() {
            return Typedef.ENUMERATED;
        }
    }

    public static class GroupedAvpPrimitive
    extends BaseAvpPrimitive {
        private final GroupedPrimitive grouped;

        @Override
        public boolean isGrouped() {
            return false;
        }

        @Override
        public GroupedAvpPrimitive toGrouped() throws ClassCastException {
            return this;
        }

        private GroupedAvpPrimitive(String name, long code, GroupedPrimitive grouped, AvpMandatory mandatoryBit, AvpProtected protectedBit, AvpVendor vendorBit, boolean mayEncrypt, Optional<Vendor> vendor) {
            super(name, code, mandatoryBit, protectedBit, vendorBit, mayEncrypt, vendor);
            this.grouped = grouped;
        }

        @Override
        public Typedef getTypedef() {
            return Typedef.GROUPED;
        }
    }

    public static class TypedAvpPrimitive
    extends BaseAvpPrimitive {
        private final Typedef typedef;

        @Override
        public boolean isTyped() {
            return true;
        }

        private TypedAvpPrimitive(String name, long code, Typedef typedef, AvpMandatory mandatoryBit, AvpProtected protectedBit, AvpVendor vendorBit, boolean mayEncrypt, Optional<Vendor> vendor) {
            super(name, code, mandatoryBit, protectedBit, vendorBit, mayEncrypt, vendor);
            this.typedef = typedef;
        }

        @Override
        public TypedAvpPrimitive toTyped() throws ClassCastException {
            return this;
        }

        @Override
        public Typedef getTypedef() {
            return this.typedef;
        }
    }

    public static abstract class BaseAvpPrimitive
    implements AvpPrimitive {
        private final String name;
        private final long code;
        private final AvpMandatory mandatoryBit;
        private final AvpProtected protectedBit;
        private final AvpVendor vendorBit;
        private final boolean mayEntrypt;
        private final Optional<Vendor> vendor;

        private BaseAvpPrimitive(String name, long code, AvpMandatory mandatoryBit, AvpProtected protectedBit, AvpVendor vendorBit, boolean mayEncrypt, Optional<Vendor> vendor) {
            this.name = name;
            this.code = code;
            this.mandatoryBit = mandatoryBit;
            this.protectedBit = protectedBit;
            this.vendorBit = vendorBit;
            this.mayEntrypt = mayEncrypt;
            this.vendor = vendor;
        }

        @Override
        public AvpMandatory getMandatoryBit() {
            return this.mandatoryBit;
        }

        @Override
        public AvpVendor getVendorBit() {
            return this.vendorBit;
        }

        @Override
        public AvpProtected getProtectedBit() {
            return this.protectedBit;
        }

        @Override
        public boolean getMayEncryptBit() {
            return this.mayEntrypt;
        }

        @Override
        public Optional<Vendor> getVendor() {
            return this.vendor;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getCode() {
            return this.code;
        }
    }

    public static class Builder
    extends DiameterSaxBuilder.BaseBuilder<AvpPrimitive> {
        private final String name;
        private final long code;
        private final AvpMandatory mandatoryBit;
        private final AvpProtected protectedBit;
        private final AvpVendor vendorBit;
        private final boolean mayEntrypt;
        private final Optional<Vendor> vendor;
        private static final List<String> acceptableChildElements = new ArrayList<String>();

        private Builder(AttributeContext ctx, String name, long code, AvpMandatory mandatoryBit, AvpProtected protectedBit, AvpVendor vendorBit, boolean mayEncrypt, Optional<Vendor> vendor) {
            super(ctx);
            this.name = name;
            this.code = code;
            this.mandatoryBit = mandatoryBit;
            this.protectedBit = protectedBit;
            this.vendorBit = vendorBit;
            this.mayEntrypt = mayEncrypt;
            this.vendor = vendor;
        }

        @Override
        protected List<String> getKnownChildElements() {
            return acceptableChildElements;
        }

        @Override
        public String getElementName() {
            return AvpPrimitive.NAME;
        }

        @Override
        public AvpPrimitive build(DiameterCollector ctx) {
            boolean isInteger32;
            Map<String, List<DiameterPrimitive>> primitives = this.buildChildren(ctx);
            Optional<Typedef> typedef = this.getType(primitives);
            Optional<GroupedPrimitive> grouped = this.getGrouped(primitives);
            List<EnumPrimitive> enums = this.getEnums(primitives);
            if (grouped.isPresent() && this.isNotEmpty(enums)) {
                String msg = String.format("Expected either a %s elements or one or more elements of type %s", "grouped", "enum");
                throw this.createException(msg);
            }
            if (grouped.isPresent() && typedef.isPresent()) {
                throw this.createException("For a Grouped AVP, we don't expect a type");
            }
            if (grouped.isPresent()) {
                GroupedAvpPrimitive avp = new GroupedAvpPrimitive(this.name, this.code, grouped.get(), this.mandatoryBit, this.protectedBit, this.vendorBit, this.mayEntrypt, this.vendor);
                ctx.collectAvp(avp);
                return avp;
            }
            Typedef base = typedef.orElse(Typedef.OCTET_STRING).getBaseType();
            boolean bl = isInteger32 = base.isInteger32() || base.isUnsigned32();
            if (this.isNotEmpty(enums) && isInteger32) {
                EnumeratedAvpPrimitive avp = new EnumeratedAvpPrimitive(this.name, this.code, enums, this.mandatoryBit, this.protectedBit, this.vendorBit, this.mayEntrypt, this.vendor);
                ctx.collectAvp(avp);
                return avp;
            }
            if (this.isNotEmpty(enums)) {
                String msg = String.format("When 'enum' is present the type is expected to be %s or %s", Typedef.ENUMERATED.getName(), Typedef.INTEGER_32.getName());
                throw this.createException(msg);
            }
            TypedAvpPrimitive avp = new TypedAvpPrimitive(this.name, this.code, typedef.orElseThrow(() -> this.createException("The AVP must specify the type")), this.mandatoryBit, this.protectedBit, this.vendorBit, this.mayEntrypt, this.vendor);
            ctx.collectAvp(avp);
            return avp;
        }

        static {
            acceptableChildElements.add("type");
            acceptableChildElements.add("enum");
            acceptableChildElements.add("grouped");
        }
    }
}

