/*
 * Decompiled with CFR 0.152.
 */
package io.snice.codecs.codegen.diameter.primitives;

import io.snice.codecs.codegen.diameter.CodeGenParseException;
import io.snice.codecs.codegen.diameter.DiameterCollector;
import io.snice.codecs.codegen.diameter.Typedef;
import io.snice.codecs.codegen.diameter.builders.AttributeContext;
import io.snice.codecs.codegen.diameter.builders.DiameterSaxBuilder;
import io.snice.codecs.codegen.diameter.primitives.DiameterPrimitive;
import java.util.Objects;

public interface EnumPrimitive
extends DiameterPrimitive {
    public static final String NAME = "enum";

    @Override
    default public String getElementName() {
        return NAME;
    }

    public long getEnumCode();

    public String getEnumName();

    @Override
    default public EnumPrimitive toEnumPrimitive() throws ClassCastException {
        return this;
    }

    public static Builder of(AttributeContext ctx) throws CodeGenParseException {
        ctx.ensureElementName(NAME);
        String original = EnumPrimitive.manualPatches(ctx.getString("name"));
        String name = original.replace("-", "_").replace("(", "_").replace(")", "_").replace(" ", "_").replace("'", "").replace("/", "_").trim();
        long code = ctx.getLong("code");
        return new Builder(ctx, name, code);
    }

    private static String manualPatches(String original) {
        if (original.equals("Roaming-Restricted-Due-To-Unsupported-Feature")) {
            return "Roaming-Restricted-Due-To-Unsupported-Feature0";
        }
        return original;
    }

    public static class DefaultEnumPrimitive
    implements EnumPrimitive {
        private final String name;
        private final long code;

        private DefaultEnumPrimitive(String name, long code) {
            this.name = name;
            this.code = code;
        }

        @Override
        public Typedef getTypedef() {
            return Typedef.ENUMERATED;
        }

        @Override
        public long getEnumCode() {
            return this.code;
        }

        @Override
        public String getEnumName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultEnumPrimitive that = (DefaultEnumPrimitive)o;
            return this.code == that.code;
        }

        public int hashCode() {
            return Objects.hash(this.code);
        }

        public String toString() {
            return this.name + "(" + this.code + ")";
        }
    }

    public static class Builder
    extends DiameterSaxBuilder.BaseBuilder<EnumPrimitive> {
        private final String name;
        private final long code;

        private Builder(AttributeContext ctx, String name, long code) {
            super(ctx);
            this.name = name;
            this.code = code;
        }

        @Override
        public String getElementName() {
            return EnumPrimitive.NAME;
        }

        @Override
        public void attachChildBuilder(DiameterSaxBuilder child) {
            throw this.createException("Unexpected child element");
        }

        @Override
        public EnumPrimitive build(DiameterCollector ctx) {
            return new DefaultEnumPrimitive(this.name, this.code);
        }
    }
}

