/*
 * Decompiled with CFR 0.152.
 */
package io.snice.codecs.codegen.diameter.primitives;

import io.snice.codecs.codegen.diameter.CodeGenParseException;
import io.snice.codecs.codegen.diameter.DiameterCollector;
import io.snice.codecs.codegen.diameter.Typedef;
import io.snice.codecs.codegen.diameter.builders.AttributeContext;
import io.snice.codecs.codegen.diameter.builders.DiameterSaxBuilder;
import io.snice.codecs.codegen.diameter.primitives.DiameterPrimitive;
import io.snice.codecs.codegen.diameter.primitives.GavpPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public interface GroupedPrimitive
extends DiameterPrimitive {
    public static final String NAME = "grouped";

    @Override
    default public Typedef getTypedef() {
        return Typedef.GROUPED;
    }

    public List<GavpPrimitive> getGroupedAvps();

    @Override
    default public String getElementName() {
        return NAME;
    }

    @Override
    default public GroupedPrimitive toGroupedPrimitive() throws ClassCastException {
        return this;
    }

    public static Builder of(AttributeContext ctx) throws CodeGenParseException {
        ctx.ensureElementName(NAME);
        return new Builder(ctx);
    }

    public static class Builder
    extends DiameterSaxBuilder.BaseBuilder<GroupedPrimitive> {
        private static final List<String> acceptableChildElements = new ArrayList<String>();

        private Builder(AttributeContext ctx) {
            super(ctx);
        }

        @Override
        protected List<String> getKnownChildElements() {
            return acceptableChildElements;
        }

        @Override
        public String getElementName() {
            return GroupedPrimitive.NAME;
        }

        @Override
        public GroupedPrimitive build(DiameterCollector ctx) {
            Map<String, List<DiameterPrimitive>> primitives = this.buildChildren(ctx);
            List<DiameterPrimitive> children = primitives.get("gavp");
            if (children == null || children.isEmpty()) {
                throw this.createException("Expected at least one 'gavp' as part of the 'grouped' element");
            }
            if (primitives.size() != 1) {
                throw this.createException("Only expected child elements of 'gavp' but found others too");
            }
            return () -> children.stream().map(DiameterPrimitive::toGavpPrimitive).collect(Collectors.toList());
        }

        static {
            acceptableChildElements.add("gavp");
        }
    }
}

