/*
 * Decompiled with CFR 0.152.
 */
package io.snice.codecs.codegen.diameter.primitives;

import io.snice.codecs.codegen.diameter.CodeGenParseException;
import io.snice.codecs.codegen.diameter.DiameterCollector;
import io.snice.codecs.codegen.diameter.builders.AttributeContext;
import io.snice.codecs.codegen.diameter.builders.DiameterSaxBuilder;
import io.snice.codecs.codegen.diameter.primitives.DiameterPrimitive;
import java.util.Optional;
import org.xml.sax.SAXException;

public interface TypedefPrimitive
extends DiameterPrimitive {
    public static final String NAME = "typedefn";

    @Override
    default public String getElementName() {
        return NAME;
    }

    @Override
    default public TypedefPrimitive toTypedefPrimitive() throws ClassCastException {
        return this;
    }

    public static Builder of(AttributeContext ctx) throws CodeGenParseException {
        ctx.ensureElementName(NAME);
        String typeName = ctx.getString("type-name");
        Optional<String> typeParent = ctx.getOptionalString("type-parent");
        return new Builder(ctx, typeName, typeParent);
    }

    public static class Builder
    extends DiameterSaxBuilder.BaseBuilder<TypedefPrimitive> {
        private final String type;
        private final Optional<String> parent;

        private Builder(AttributeContext ctx, String type, Optional<String> parent) {
            super(ctx);
            this.type = type;
            this.parent = parent;
        }

        @Override
        public String getElementName() {
            return TypedefPrimitive.NAME;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            char[] copy = new char[length];
            System.arraycopy(ch, start, copy, 0, length);
            System.err.println(new String(copy));
        }

        @Override
        public void attachChildBuilder(DiameterSaxBuilder child) {
            throw this.createException("Unexpected child element");
        }

        @Override
        public TypedefPrimitive build(DiameterCollector ctx) {
            return null;
        }
    }
}

