/*
 * Decompiled with CFR 0.152.
 */
package io.snice.codecs.codegen.diameter.templates;

import io.snice.codecs.codegen.diameter.config.Attributes;
import io.snice.codecs.codegen.diameter.templates.AvpTemplate;
import io.snice.preconditions.PreConditions;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import liqp.RenderSettings;
import liqp.Template;

public class AvpFramerTemplate {
    private final Template template;

    public static AvpFramerTemplate load() throws URISyntaxException, IOException {
        URI uri = AvpFramerTemplate.class.getResource("avp_framer_template.liquid").toURI();
        AvpTemplate.ensureFileSystem(uri);
        Path p = Paths.get(uri);
        String liquid = Files.readString(p);
        RenderSettings settings = new RenderSettings.Builder().withStrictVariables(false).build();
        Template template = Template.parse((String)liquid).withRenderSettings(settings);
        return new AvpFramerTemplate(template);
    }

    private AvpFramerTemplate(Template template) {
        this.template = template;
    }

    public String render(Attributes framerAttributes, List<Attributes> avps) {
        PreConditions.assertCollectionNotEmpty(avps);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("framer", framerAttributes);
        map.put("avps", avps);
        return this.template.render(map);
    }
}

