/*
 * Decompiled with CFR 0.152.
 */
package io.snice.codecs.codegen.diameter.templates;

import io.snice.codecs.codegen.diameter.primitives.AvpPrimitive;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import liqp.RenderSettings;
import liqp.Template;

public class AvpTemplate {
    private final Template template;
    private final AvpPrimitive avp;

    public static AvpTemplate load(AvpPrimitive avp) throws URISyntaxException, IOException {
        URI uri = avp.isEnumerated() ? AvpTemplate.class.getResource("avp_enumerated_template.liquid").toURI() : AvpTemplate.class.getResource("avp_template.liquid").toURI();
        AvpTemplate.ensureFileSystem(uri);
        Path p = Paths.get(uri);
        String liquid = Files.readString(p);
        RenderSettings settings = new RenderSettings.Builder().withStrictVariables(false).build();
        Template template = Template.parse((String)liquid).withRenderSettings(settings);
        return new AvpTemplate(avp, template);
    }

    public static FileSystem ensureFileSystem(URI uri) {
        try {
            if ("jar".equals(uri.getScheme())) {
                HashMap<String, String> env = new HashMap<String, String>();
                env.put("create", "true");
                return FileSystems.newFileSystem(uri, env);
            }
        }
        catch (IOException | FileSystemAlreadyExistsException exception) {
            // empty catch block
        }
        return FileSystems.getDefault();
    }

    private AvpTemplate(AvpPrimitive avp, Template template) {
        this.avp = avp;
        this.template = template;
    }

    public String render(Map<String, Object> attributes) {
        return this.template.render(attributes);
    }
}

