/*
 * Decompiled with CFR 0.152.
 */
package io.snice.codecs.codegen.diameter;

import java.util.Optional;
import java.util.stream.Stream;

public enum Typedef {
    OCTET_STRING("OctetString", null, "OctetString", "DiameterOctetStringAvp"),
    INTEGER_32("Integer32", null, "Integer32", "DiameterInteger32Avp"),
    INTEGER_64("Integer64", null, "Integer64", null),
    UNSIGNED_32("Unsigned32", null, "Unsigned32", "DiameterUnsigned32Avp"),
    UNSIGNED_64("Unsigned64", null, null, null),
    FLOAT_32("Float32", null, null, null),
    FLOAT_64("Float64", null, null, null),
    TIME("Time", null, "Time", "TimeAvp"),
    UTF8_STRING("UTF8String", OCTET_STRING, "UTF8String", "DiameterUtf8StringAvp"),
    ENUMERATED("Enumerated", INTEGER_32, "Enumerated", "DiameterEnumeratedAvp"),
    GROUPED("Grouped", null, "Grouped", "DiameterGroupedAvp"),
    GAVP("Gavp", null, "Grouped", "DiameterGroupedAvp"),
    DIAMETER_URI("DiameterURI", UTF8_STRING, null, null),
    IP_ADDRESS("IPAddress", OCTET_STRING, "IpAddress", "DiameterIpAddressAvp"),
    DIAMETER_IDENTITY("DiameterIdentity", OCTET_STRING, "DiameterIdentity", "DiameterIdentityAvp"),
    IP_FILTER_RULE("IPFilterRule", OCTET_STRING, null, null),
    QoS_FILTER_RULE("QoSFilterRule", OCTET_STRING, null, null),
    MIP_REGISTRATION_REQUEST("MIPRegistrationRequest", OCTET_STRING, null, null),
    VENDOR_ID("VendorId", UNSIGNED_32, "Unsigned32", "DiameterUnsigned32Avp"),
    APP_ID("AppId", UNSIGNED_32, "Unsigned32", "DiameterUnsigned32Avp");

    private final Optional<String> implementingInterface;
    private final Optional<String> implementingInterfaceFqdn;
    private final Optional<String> implementingClass;
    private final Optional<String> implementingClassFqdn;
    private final Typedef parent;
    private final String name;

    public static Typedef fromName(String name) {
        return Stream.of(Typedef.values()).filter(t -> name.equalsIgnoreCase(t.name)).findFirst().orElseThrow(() -> new IllegalArgumentException("No enum constant " + Typedef.class.getCanonicalName() + "." + name));
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getImplementingClass() {
        return this.implementingClass;
    }

    public Optional<String> getImplementingClassFqdn() {
        return this.implementingClassFqdn;
    }

    public Optional<String> getImplementingInterface() {
        return this.implementingInterface;
    }

    public Optional<String> getImplementingInterfaceFqdn() {
        return this.implementingInterfaceFqdn;
    }

    public boolean isUnsigned32() {
        return this == UNSIGNED_32;
    }

    public boolean isInteger32() {
        return this == INTEGER_32;
    }

    public boolean isEnumerated() {
        return this == ENUMERATED;
    }

    private Typedef(String name, Typedef parent, String implementingInterface, String implementingClass) {
        String implementingPackage = "io.snice.codecs.codec.diameter.avp.type";
        String implementingPackageImpl = "io.snice.codecs.codec.diameter.avp.impl";
        this.implementingInterface = Optional.ofNullable(implementingInterface);
        this.implementingInterfaceFqdn = this.implementingInterface.map(clazz -> "io.snice.codecs.codec.diameter.avp.type." + clazz);
        this.implementingClass = Optional.ofNullable(implementingClass);
        this.implementingClassFqdn = this.implementingClass.map(clazz -> "io.snice.codecs.codec.diameter.avp.impl." + clazz);
        this.name = name;
        this.parent = parent;
    }

    public Typedef getBaseType() {
        return this.parent != null ? this.parent : this;
    }
}

