/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit5;

import io.specto.hoverfly.junit.core.Hoverfly;
import io.specto.hoverfly.junit.core.HoverflyMode;
import io.specto.hoverfly.junit.core.SimulationSource;
import io.specto.hoverfly.junit5.AutoCaptureSource;
import io.specto.hoverfly.junit5.HoverflyExtensionUtils;
import io.specto.hoverfly.junit5.api.HoverflyCapture;
import io.specto.hoverfly.junit5.api.HoverflyConfig;
import io.specto.hoverfly.junit5.api.HoverflyCore;
import io.specto.hoverfly.junit5.api.HoverflySimulate;
import java.lang.reflect.AnnotatedElement;
import java.nio.file.Path;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;

public class HoverflyExtension
implements BeforeEachCallback,
AfterAllCallback,
BeforeAllCallback,
ParameterResolver {
    private Hoverfly hoverfly;
    private SimulationSource source = SimulationSource.empty();
    private HoverflyMode mode = HoverflyMode.SIMULATE;
    private Path capturePath;

    public void beforeEach(ExtensionContext context) throws Exception {
        if (this.isRunning()) {
            this.hoverfly.resetJournal();
            this.hoverfly.resetMode(this.mode);
            if (this.mode == HoverflyMode.SIMULATE) {
                this.hoverfly.simulate(this.source);
            }
        }
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        AnnotatedElement annotatedElement = (AnnotatedElement)context.getElement().orElseThrow(() -> new IllegalStateException("No test class found."));
        HoverflyConfig config = null;
        if (AnnotationSupport.isAnnotated((AnnotatedElement)annotatedElement, HoverflySimulate.class)) {
            HoverflySimulate hoverflySimulate = annotatedElement.getAnnotation(HoverflySimulate.class);
            config = hoverflySimulate.config();
            HoverflySimulate.SourceType type = hoverflySimulate.source().type();
            String path = hoverflySimulate.source().value();
            if (path.isEmpty()) {
                path = context.getTestClass().map(HoverflyExtensionUtils::getFileNameFromTestClass).orElseThrow(() -> new IllegalStateException("No test class found."));
            }
            if (hoverflySimulate.enableAutoCapture()) {
                AutoCaptureSource.newInstance(path, type).ifPresent(source -> {
                    this.mode = HoverflyMode.CAPTURE;
                    this.capturePath = source.getCapturePath();
                });
            }
            this.source = HoverflyExtensionUtils.getSimulationSource(path, type);
        } else if (AnnotationSupport.isAnnotated((AnnotatedElement)annotatedElement, HoverflyCore.class)) {
            HoverflyCore hoverflyCore = annotatedElement.getAnnotation(HoverflyCore.class);
            config = hoverflyCore.config();
            this.mode = hoverflyCore.mode();
        } else if (AnnotationSupport.isAnnotated((AnnotatedElement)annotatedElement, HoverflyCapture.class)) {
            HoverflyCapture hoverflyCapture = annotatedElement.getAnnotation(HoverflyCapture.class);
            config = hoverflyCapture.config();
            this.mode = HoverflyMode.CAPTURE;
            String filename = hoverflyCapture.filename();
            if (filename.isEmpty()) {
                filename = context.getTestClass().map(HoverflyExtensionUtils::getFileNameFromTestClass).orElseThrow(() -> new IllegalStateException("Failed to resolve capture filename."));
            }
            this.capturePath = HoverflyExtensionUtils.getCapturePath(hoverflyCapture.path(), filename);
        }
        if (!this.isRunning()) {
            this.hoverfly = new Hoverfly(HoverflyExtensionUtils.getHoverflyConfigs(config), this.mode);
            this.hoverfly.start();
        }
        if (this.mode == HoverflyMode.SIMULATE) {
            this.hoverfly.simulate(this.source);
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (this.isRunning()) {
            try {
                if (this.capturePath != null) {
                    this.hoverfly.exportSimulation(this.capturePath);
                }
            }
            finally {
                this.hoverfly.close();
                this.hoverfly = null;
            }
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return Hoverfly.class.isAssignableFrom(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.hoverfly;
    }

    private boolean isRunning() {
        return this.hoverfly != null;
    }
}

