/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit5;

import io.specto.hoverfly.junit.core.SimulationSource;
import io.specto.hoverfly.junit5.api.HoverflyConfig;
import io.specto.hoverfly.junit5.api.HoverflySimulate;
import java.nio.file.Path;
import java.nio.file.Paths;

class HoverflyExtensionUtils {
    private HoverflyExtensionUtils() {
    }

    static io.specto.hoverfly.junit.core.HoverflyConfig getHoverflyConfigs(HoverflyConfig config) {
        if (config != null) {
            io.specto.hoverfly.junit.core.HoverflyConfig configs = io.specto.hoverfly.junit.core.HoverflyConfig.configs().sslCertificatePath(config.sslCertificatePath()).sslKeyPath(config.sslKeyPath()).adminPort(config.adminPort()).proxyPort(config.proxyPort()).destination(config.destination()).captureHeaders(config.captureHeaders());
            if (config.proxyLocalHost()) {
                configs.proxyLocalHost();
            }
            if (config.captureAllHeaders()) {
                configs.captureAllHeaders();
            }
            if (!config.remoteHost().isEmpty()) {
                configs.remote().host(config.remoteHost());
            }
            return configs;
        }
        return io.specto.hoverfly.junit.core.HoverflyConfig.configs();
    }

    static SimulationSource getSimulationSource(String value, HoverflySimulate.SourceType type) {
        SimulationSource source = SimulationSource.empty();
        switch (type) {
            case DEFAULT_PATH: {
                source = SimulationSource.defaultPath((String)value);
                break;
            }
            case URL: {
                source = SimulationSource.url((String)value);
                break;
            }
            case CLASSPATH: {
                source = SimulationSource.classpath((String)value);
                break;
            }
            case FILE: {
                source = SimulationSource.file((Path)Paths.get(value, new String[0]));
            }
        }
        return source;
    }

    static String getFileNameFromTestClass(Class<?> testClass) {
        return testClass.getCanonicalName().replace('.', '_').replace('$', '_').concat(".json");
    }

    static Path getCapturePath(String path, String filename) {
        if (path.isEmpty()) {
            path = "src/test/resources/hoverfly";
        }
        return Paths.get(path, new String[0]).resolve(filename);
    }
}

