/*
 * Decompiled with CFR 0.152.
 */
package io.split.api.client.interceptors;

import io.split.api.SplitApiClientConfig;
import java.io.IOException;
import java.net.InetAddress;
import split.org.apache.http.HttpException;
import split.org.apache.http.HttpRequest;
import split.org.apache.http.HttpRequestInterceptor;
import split.org.apache.http.protocol.HttpContext;
import split.org.slf4j.Logger;
import split.org.slf4j.LoggerFactory;

public class AddSplitHeadersFilter
implements HttpRequestInterceptor {
    private static final Logger _log = LoggerFactory.getLogger(AddSplitHeadersFilter.class);
    private static final String CLIENT_MACHINE_NAME_HEADER = "SplitSDKMachineName";
    private static final String CLIENT_MACHINE_IP_HEADER = "SplitSDKMachineIP";
    private static final String CLIENT_VERSION = "SplitSDKVersion";
    private static final String SDK_SPEC_VERSION = "SplitSDKSpecVersion";
    private static final String OUR_SDK_SPEC_VERSION = "1.0";
    private final String _apiTokenBearer;
    private final String _hostname;
    private final String _ip;

    public static AddSplitHeadersFilter instance(String apiToken) {
        String hostname = null;
        String ip = null;
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            hostname = localHost.getHostName();
            ip = localHost.getHostAddress();
        }
        catch (Exception e) {
            _log.error("Could not resolve InetAddress", e);
        }
        return new AddSplitHeadersFilter(apiToken, hostname, ip);
    }

    private AddSplitHeadersFilter(String apiToken, String hostname, String ip) {
        this._apiTokenBearer = "Bearer " + apiToken;
        this._hostname = hostname;
        this._ip = ip;
    }

    @Override
    public void process(HttpRequest request, HttpContext httpContext) throws HttpException, IOException {
        request.addHeader("Authorization", this._apiTokenBearer);
        request.addHeader(CLIENT_VERSION, SplitApiClientConfig.splitSdkVersion);
        request.addHeader(SDK_SPEC_VERSION, OUR_SDK_SPEC_VERSION);
        if (this._hostname != null) {
            request.addHeader(CLIENT_MACHINE_NAME_HEADER, this._hostname);
        }
        if (this._ip != null) {
            request.addHeader(CLIENT_MACHINE_IP_HEADER, this._ip);
        }
    }
}

