/*
 * Decompiled with CFR 0.152.
 */
package io.split.api.dtos;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Attribute {
    private String id;
    private String organizationId;
    private String trafficTypeId;
    private String displayName;
    private String description;
    private String dataType;
    private boolean searchable;

    public Attribute() {
        this.searchable = false;
    }

    private Attribute(Builder builder) {
        this.id = builder.id;
        this.organizationId = builder.organizationId;
        this.trafficTypeId = builder.trafficTypeId;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.dataType = builder.dataType;
        this.searchable = builder.searchable;
    }

    @JsonProperty
    public String id() {
        return this.id;
    }

    @JsonProperty
    public String organizationId() {
        return this.organizationId;
    }

    @JsonProperty
    public String trafficTypeId() {
        return this.trafficTypeId;
    }

    @JsonProperty
    public String displayName() {
        return this.displayName;
    }

    @JsonProperty
    public String description() {
        return this.description;
    }

    @JsonProperty
    public String dataType() {
        return this.dataType;
    }

    @JsonProperty(value="isSearchable")
    public boolean isSearchable() {
        return this.searchable;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public void setTrafficTypeId(String trafficTypeId) {
        this.trafficTypeId = trafficTypeId;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Attribute other) {
        return new Builder(other);
    }

    public String toString() {
        return "Attribute{id='" + this.id + '\'' + ", organizationId='" + this.organizationId + '\'' + ", trafficTypeId='" + this.trafficTypeId + '\'' + ", displayName='" + this.displayName + '\'' + ", description='" + this.description + '\'' + ", dataType='" + this.dataType + '\'' + ", searchable=" + this.searchable + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        if (this.searchable != attribute.searchable) {
            return false;
        }
        if (this.id != null ? !this.id.equals(attribute.id) : attribute.id != null) {
            return false;
        }
        if (this.organizationId != null ? !this.organizationId.equals(attribute.organizationId) : attribute.organizationId != null) {
            return false;
        }
        if (this.trafficTypeId != null ? !this.trafficTypeId.equals(attribute.trafficTypeId) : attribute.trafficTypeId != null) {
            return false;
        }
        if (this.displayName != null ? !this.displayName.equals(attribute.displayName) : attribute.displayName != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(attribute.description) : attribute.description != null) {
            return false;
        }
        return this.dataType != null ? this.dataType.equals(attribute.dataType) : attribute.dataType == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.organizationId != null ? this.organizationId.hashCode() : 0);
        result = 31 * result + (this.trafficTypeId != null ? this.trafficTypeId.hashCode() : 0);
        result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
        result = 31 * result + (this.searchable ? 1 : 0);
        return result;
    }

    public static class Builder {
        private String id;
        private String organizationId;
        private String trafficTypeId;
        private String displayName;
        private String description;
        private String dataType;
        private boolean searchable;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public Builder trafficTypeId(String trafficTypeId) {
            this.trafficTypeId = trafficTypeId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder searchable(boolean searchable) {
            this.searchable = searchable;
            return this;
        }

        Builder() {
        }

        Builder(Attribute prototype) {
            this.id = prototype.id;
            this.organizationId = prototype.organizationId;
            this.trafficTypeId = prototype.trafficTypeId;
            this.displayName = prototype.displayName;
            this.description = prototype.description;
            this.dataType = prototype.dataType;
            this.searchable = prototype.searchable;
        }

        public Attribute build() {
            return new Attribute(this);
        }
    }
}

