/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.testing.runner;

import io.split.client.testing.annotations.SplitScenario;
import io.split.client.testing.annotations.SplitSuite;
import io.split.client.testing.annotations.SplitTest;
import io.split.client.testing.annotations.SplitTestClient;
import io.split.client.testing.runner.Scenario;
import java.util.HashSet;
import java.util.Set;

public class Suite {
    private Set<Scenario> _scenarios;

    public Suite() {
        this._scenarios = new HashSet<Scenario>();
        this._scenarios.add(new Scenario());
    }

    public Suite(Suite other) {
        this._scenarios = new HashSet<Scenario>(other._scenarios);
    }

    public Suite(SplitTest splitTest) {
        SplitTest[] splitTests = new SplitTest[]{splitTest};
        this._scenarios = Suite.permuteTests(splitTests);
    }

    public Suite(SplitScenario splitScenario) {
        this._scenarios = Suite.permuteTests(splitScenario.tests());
    }

    public Suite(SplitSuite splitSuite) {
        this._scenarios = new HashSet<Scenario>();
        for (SplitScenario scenario : splitSuite.scenarios()) {
            this._scenarios.addAll(Suite.permuteTests(scenario.tests()));
        }
    }

    public Suite(SplitTestClient splitTestClient) {
        this._scenarios = new HashSet<Scenario>();
        for (SplitScenario scenario : splitTestClient.scenarios()) {
            this._scenarios.addAll(Suite.permuteTests(scenario.tests()));
        }
    }

    private static Set<Scenario> permuteTests(SplitTest[] splitTests) {
        HashSet<Scenario> scenarios = new HashSet<Scenario>();
        scenarios.add(new Scenario());
        for (SplitTest test : splitTests) {
            HashSet<Scenario> permutedScenarios = new HashSet<Scenario>();
            for (String treatment : test.treatments()) {
                for (Scenario scenario : scenarios) {
                    Scenario permutedScenario = new Scenario(scenario);
                    permutedScenario.addTest(test.feature(), treatment);
                    permutedScenarios.add(permutedScenario);
                }
            }
            scenarios = permutedScenarios;
        }
        return scenarios;
    }

    public Set<Scenario> scenarios() {
        return this._scenarios;
    }

    public Suite merge(Set<Scenario> newScenarios) {
        HashSet<Scenario> mergedScenarios = new HashSet<Scenario>();
        for (Scenario existingScenario : this._scenarios) {
            for (Scenario newScenario : newScenarios) {
                Scenario scenario = new Scenario(existingScenario);
                scenario.merge(newScenario);
                mergedScenarios.add(scenario);
            }
        }
        if (mergedScenarios.isEmpty()) {
            mergedScenarios.addAll(this._scenarios);
            mergedScenarios.addAll(newScenarios);
        }
        this._scenarios = mergedScenarios;
        return this;
    }

    public Suite merge(Suite suite) {
        return this.merge(suite.scenarios());
    }

    public boolean isOnlyAllControl() {
        return this._scenarios == null || this._scenarios.isEmpty() || this._scenarios.size() == 1 && this._scenarios.iterator().next().tests().isEmpty();
    }
}

