/*
 * Decompiled with CFR 0.152.
 */
package io.translateplus;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.translateplus.TranslatePlusAPIError;
import io.translateplus.TranslatePlusAuthenticationError;
import io.translateplus.TranslatePlusInsufficientCreditsError;
import io.translateplus.TranslatePlusRateLimitError;
import io.translateplus.TranslatePlusValidationError;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class TranslatePlusClient {
    private static final String DEFAULT_BASE_URL = "https://api.translateplus.io";
    private static final int DEFAULT_TIMEOUT = 30;
    private static final int DEFAULT_MAX_RETRIES = 3;
    private static final int DEFAULT_MAX_CONCURRENT = 5;
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private final String apiKey;
    private final String baseUrl;
    private final int timeout;
    private final int maxRetries;
    private final int maxConcurrent;
    private final OkHttpClient httpClient;
    private final Gson gson;
    private final Semaphore semaphore;

    private TranslatePlusClient(Builder builder) {
        if (builder.apiKey == null || builder.apiKey.isEmpty()) {
            throw new TranslatePlusValidationError("API key is required");
        }
        this.apiKey = builder.apiKey;
        this.baseUrl = builder.baseUrl != null ? builder.baseUrl.replaceAll("/$", "") : DEFAULT_BASE_URL;
        this.timeout = builder.timeout > 0 ? builder.timeout : 30;
        this.maxRetries = builder.maxRetries > 0 ? builder.maxRetries : 3;
        this.maxConcurrent = builder.maxConcurrent > 0 ? builder.maxConcurrent : 5;
        this.semaphore = new Semaphore(this.maxConcurrent);
        this.httpClient = new OkHttpClient.Builder().connectTimeout((long)this.timeout, TimeUnit.SECONDS).readTimeout((long)this.timeout, TimeUnit.SECONDS).writeTimeout((long)this.timeout, TimeUnit.SECONDS).build();
        this.gson = new GsonBuilder().create();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> makeRequest(String method, String endpoint, Map<String, Object> data, Map<String, File> files, Map<String, String> params) {
        block40: {
            block38: {
                try {
                    this.semaphore.acquire();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new TranslatePlusAPIError("Request interrupted", null);
                }
                try {
                    url = this.baseUrl + "/" + endpoint.replaceAll("^/", "");
                    if (params != null && !params.isEmpty()) {
                        urlBuilder = HttpUrl.parse((String)url).newBuilder();
                        for (Map.Entry<String, String> param : params.entrySet()) {
                            urlBuilder.addQueryParameter(param.getKey(), param.getValue());
                        }
                        url = urlBuilder.build().toString();
                    }
                    requestBuilder = new Request.Builder().url((String)url).addHeader("X-API-KEY", this.apiKey).addHeader("User-Agent", "translateplus-java/1.0.0");
                    requestBody = null;
                    if (files != null && !files.isEmpty()) {
                        multipartBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
                        if (data != null) {
                            for (Map.Entry<String, Object> var11_12 : data.entrySet()) {
                                multipartBuilder.addFormDataPart(var11_12.getKey(), String.valueOf(var11_12.getValue()));
                            }
                        }
                        for (Map.Entry<String, Object> var11_14 : files.entrySet()) {
                            file = (File)var11_14.getValue();
                            if (!file.exists()) {
                                throw new TranslatePlusValidationError("File not found: " + file.getPath());
                            }
                            multipartBuilder.addFormDataPart(var11_14.getKey(), file.getName(), RequestBody.create((File)file, (MediaType)MediaType.parse((String)"application/octet-stream")));
                        }
                        requestBody = multipartBuilder.build();
                    } else if (data != null) {
                        json = this.gson.toJson(data);
                        requestBody = RequestBody.create((String)json, (MediaType)TranslatePlusClient.JSON);
                    }
                    request = requestBuilder.method(method, requestBody).build();
                    lastError = null;
                    var11_15 = false;
                    while (var11_16 <= this.maxRetries) {
                        block39: {
                            try {
                                response = this.httpClient.newCall(request).execute();
                                statusCode = response.code();
                                v0 = body = response.body() != null ? response.body().string() : "{}";
                                if (statusCode >= 200 && statusCode < 300) {
                                    if (body != null && !body.isEmpty()) break block38;
                                    var15_25 = new HashMap<String, Object>();
                                    if (response == null) break block39;
                                }
                                ** GOTO lbl-1000
                                response.close();
                            }
                            catch (TranslatePlusAuthenticationError | TranslatePlusInsufficientCreditsError e) {
                                throw e;
                            }
                            catch (IOException e) {
                                lastError = e;
                                if (var11_16 < this.maxRetries) {
                                    try {
                                        Thread.sleep((long)Math.pow(2.0, (double)var11_16) * 1000L);
                                    }
                                    catch (InterruptedException ie) {
                                        Thread.currentThread().interrupt();
                                        throw new TranslatePlusAPIError("Request interrupted", null);
                                    }
                                }
                                ++var11_16;
                                continue;
                            }
                        }
                        this.semaphore.release();
                        return var15_25;
                    }
                    break block40;
                }
                catch (Throwable var18_30) {
                    this.semaphore.release();
                    throw var18_30;
                }
            }
            ** try [egrp 5[TRYBLOCK] [3 : 553->569)] { 
lbl78:
            // 1 sources

            return (Map)this.gson.fromJson(body, Map.class);
lbl-1000:
            // 1 sources

            {
                errorData = new HashMap<K, V>();
                errorMessage = "API request failed with status " + statusCode;
                try {
                    errorData = (Map)this.gson.fromJson(body, Map.class);
                    if (errorData.containsKey("detail")) {
                        errorMessage = String.valueOf(errorData.get("detail"));
                    }
                }
                catch (Exception var17_29) {
                    // empty catch block
                }
                if (statusCode == 401) throw new TranslatePlusAuthenticationError((String)errorMessage, statusCode, errorData);
                if (statusCode == 403) {
                    throw new TranslatePlusAuthenticationError((String)errorMessage, statusCode, errorData);
                }
                if (statusCode == 402) {
                    throw new TranslatePlusInsufficientCreditsError((String)errorMessage, statusCode, errorData);
                }
                if (statusCode != 429) throw new TranslatePlusAPIError((String)errorMessage, statusCode, errorData);
                throw new TranslatePlusRateLimitError((String)errorMessage, statusCode, errorData);
            }
lbl95:
            // 1 sources

            finally {
                if (response == null) {
                    this.semaphore.release();
                    return var15_26;
                }
                response.close();
            }
        }
        if (lastError != null) {
            v1 = lastError.getMessage();
            throw new TranslatePlusAPIError("Request failed after " + this.maxRetries + " retries: " + v1, null);
        }
        v1 = "Unknown error";
        throw new TranslatePlusAPIError("Request failed after " + this.maxRetries + " retries: " + v1, null);
    }

    public Map<String, Object> translate(String text, String source, String target) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("text", text);
        data.put("source", source != null ? source : "auto");
        data.put("target", target);
        return this.makeRequest("POST", "/v2/translate", data, null, null);
    }

    public Map<String, Object> translateBatch(List<String> texts, String source, String target) {
        if (texts == null || texts.isEmpty()) {
            throw new TranslatePlusValidationError("Texts list cannot be empty");
        }
        if (texts.size() > 100) {
            throw new TranslatePlusValidationError("Maximum 100 texts allowed per batch request");
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("texts", texts);
        data.put("source", source != null ? source : "auto");
        data.put("target", target);
        return this.makeRequest("POST", "/v2/translate/batch", data, null, null);
    }

    public Map<String, Object> translateHTML(String html, String source, String target) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("html", html);
        data.put("source", source != null ? source : "auto");
        data.put("target", target);
        return this.makeRequest("POST", "/v2/translate/html", data, null, null);
    }

    public Map<String, Object> translateEmail(String subject, String emailBody, String source, String target) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("subject", subject);
        data.put("email_body", emailBody);
        data.put("source", source != null ? source : "auto");
        data.put("target", target);
        return this.makeRequest("POST", "/v2/translate/email", data, null, null);
    }

    public Map<String, Object> translateSubtitles(String content, String format, String source, String target) {
        if (!format.equals("srt") && !format.equals("vtt")) {
            throw new TranslatePlusValidationError("Format must be 'srt' or 'vtt'");
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("content", content);
        data.put("format", format);
        data.put("source", source != null ? source : "auto");
        data.put("target", target);
        return this.makeRequest("POST", "/v2/translate/subtitles", data, null, null);
    }

    public Map<String, Object> detectLanguage(String text) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("text", text);
        return this.makeRequest("POST", "/v2/language_detect", data, null, null);
    }

    public Map<String, Object> getSupportedLanguages() {
        return this.makeRequest("GET", "/v2/supported_languages", null, null, null);
    }

    public Map<String, Object> getAccountSummary() {
        return this.makeRequest("GET", "/v2/account/summary", null, null, null);
    }

    public Map<String, Object> createI18nJob(File filePath, List<String> targetLanguages, String sourceLanguage, String webhookUrl) {
        if (filePath == null || !filePath.exists()) {
            throw new TranslatePlusValidationError("File not found: " + (filePath != null ? filePath.getPath() : "null"));
        }
        if (targetLanguages == null || targetLanguages.isEmpty()) {
            throw new TranslatePlusValidationError("targetLanguages must be a non-empty list");
        }
        HashMap<String, Object> formData = new HashMap<String, Object>();
        formData.put("source_language", sourceLanguage != null ? sourceLanguage : "auto");
        formData.put("target_languages", String.join((CharSequence)",", targetLanguages));
        if (webhookUrl != null && !webhookUrl.isEmpty()) {
            formData.put("webhook_url", webhookUrl);
        }
        HashMap<String, File> files = new HashMap<String, File>();
        files.put("file", filePath);
        return this.makeRequest("POST", "/v2/i18n/create_job", formData, files, null);
    }

    public Map<String, Object> getI18nJobStatus(String jobId) {
        return this.makeRequest("GET", "/v2/i18n/job/" + jobId, null, null, null);
    }

    public Map<String, Object> listI18nJobs(Integer page, Integer pageSize) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("page", String.valueOf(page != null ? page : 1));
        params.put("page_size", String.valueOf(pageSize != null ? pageSize : 10));
        return this.makeRequest("GET", "/v2/i18n/jobs", null, null, params);
    }

    public static class Builder {
        private String apiKey;
        private String baseUrl;
        private int timeout;
        private int maxRetries;
        private int maxConcurrent;

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder maxConcurrent(int maxConcurrent) {
            this.maxConcurrent = maxConcurrent;
            return this;
        }

        public TranslatePlusClient build() {
            return new TranslatePlusClient(this);
        }
    }
}

