/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.buffer;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import java.util.Arrays;
import java.util.Base64;

@DataObject
public interface Buffer {
    public static Buffer fromJson(String base64) {
        Base64.Decoder decoder = Base64.getUrlDecoder();
        byte[] bytes = decoder.decode(base64);
        return Buffer.buffer(bytes);
    }

    @GenIgnore(value={"permitted-type"})
    public static Buffer buffer(final byte[] bytes) {
        return new Buffer(){

            @Override
            public byte[] getBytes() {
                return bytes;
            }

            public boolean equals(Object obj) {
                if (obj instanceof Buffer) {
                    Buffer that = (Buffer)obj;
                    return Arrays.equals(bytes, that.getBytes());
                }
                return false;
            }
        };
    }

    @GenIgnore(value={"permitted-type"})
    public byte[] getBytes();

    default public String toJson() {
        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
        return encoder.encodeToString(this.getBytes());
    }
}

