/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json;

import io.vertx.core.json.JsonArray;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;

public class JsonObject
implements Iterable<Map.Entry<String, Object>> {
    private final Map<String, Object> map;

    public JsonObject() {
        this(new HashMap<String, Object>());
    }

    public JsonObject(Map<String, Object> map) {
        this.map = map;
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.map.entrySet().iterator();
    }

    public <T> T getValue(String name) {
        return (T)this.map.get(name);
    }

    private <T> T getValue(String name, T def) {
        Object val = this.map.get(name);
        if (val == null) {
            return def;
        }
        return (T)val;
    }

    public void remove(String name) {
        this.map.remove(name);
    }

    public JsonObject copy() {
        return new JsonObject(new HashMap<String, Object>(this.map));
    }

    public int size() {
        return this.map.size();
    }

    public JsonObject put(String fieldName, Object value) {
        this.map.put(fieldName, value);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JsonObject) {
            JsonObject that = (JsonObject)obj;
            return this.map.equals(that.map);
        }
        return false;
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public JsonObject getJsonObject(String name) {
        throw new UnsupportedOperationException();
    }

    public String getString(String name) {
        return (String)this.getValue(name);
    }

    public String getString(String name, String def) {
        throw new UnsupportedOperationException();
    }

    public Instant getInstant(String name) {
        throw new UnsupportedOperationException();
    }

    public Instant getInstant(String name, Instant def) {
        throw new UnsupportedOperationException();
    }

    public Integer getInteger(String fieldName) {
        throw new UnsupportedOperationException();
    }

    public Boolean getBoolean(String fieldName, Boolean def) {
        throw new UnsupportedOperationException();
    }

    public Integer getInteger(String fieldName, Integer def) {
        return this.getValue(fieldName, def);
    }

    public Long getLong(String fieldName, Long def) {
        throw new UnsupportedOperationException();
    }

    public Float getFloat(String fieldName, Float def) {
        throw new UnsupportedOperationException();
    }

    public Double getDouble(String fieldName, Double def) {
        throw new UnsupportedOperationException();
    }

    public JsonArray getJsonArray(String name) {
        throw new UnsupportedOperationException();
    }

    public byte[] getBinary(String name) {
        throw new UnsupportedOperationException();
    }

    public Stream<Map.Entry<String, Object>> stream() {
        throw new UnsupportedOperationException();
    }
}

