/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.testmodel;

import io.vertx.codegen.testmodel.CollectionTCK;
import io.vertx.codegen.testmodel.RefedInterface1;
import io.vertx.codegen.testmodel.RefedInterface1Impl;
import io.vertx.codegen.testmodel.RefedInterface2;
import io.vertx.codegen.testmodel.RefedInterface2Impl;
import io.vertx.codegen.testmodel.TestDataObject;
import io.vertx.codegen.testmodel.TestEnum;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;

public class CollectionTCKImpl
implements CollectionTCK {
    @Override
    public void methodWithListParams(List<String> listString, List<Byte> listByte, List<Short> listShort, List<Integer> listInt, List<Long> listLong, List<JsonObject> listJsonObject, List<JsonArray> listJsonArray, List<RefedInterface1> listVertxGen, List<TestDataObject> listDataObject, List<TestEnum> listEnum, List<Object> listObject) {
        Assert.assertEquals((Object)"foo", (Object)listString.get(0));
        Assert.assertEquals((Object)"bar", (Object)listString.get(1));
        Assert.assertEquals((long)2L, (long)listByte.get(0).byteValue());
        Assert.assertEquals((long)3L, (long)listByte.get(1).byteValue());
        Assert.assertEquals((long)12L, (long)listShort.get(0).shortValue());
        Assert.assertEquals((long)13L, (long)listShort.get(1).shortValue());
        Assert.assertEquals((long)1234L, (long)listInt.get(0).intValue());
        Assert.assertEquals((long)1345L, (long)listInt.get(1).intValue());
        System.out.println("entry type is " + listLong.get(0).getClass().getName());
        Assert.assertEquals((long)123L, (long)listLong.get(0));
        Assert.assertEquals((long)456L, (long)listLong.get(1));
        Assert.assertEquals((Object)new JsonObject().put("foo", (Object)"bar"), (Object)listJsonObject.get(0));
        Assert.assertEquals((Object)new JsonObject().put("eek", (Object)"wibble"), (Object)listJsonObject.get(1));
        Assert.assertEquals((Object)new JsonArray().add((Object)"foo"), (Object)listJsonArray.get(0));
        Assert.assertEquals((Object)new JsonArray().add((Object)"blah"), (Object)listJsonArray.get(1));
        Assert.assertEquals((Object)"foo", (Object)listVertxGen.get(0).getString());
        Assert.assertEquals((Object)"bar", (Object)listVertxGen.get(1).getString());
        Assert.assertEquals((Object)new JsonObject().put("foo", (Object)"String 1").put("bar", (Object)1).put("wibble", (Object)1.1), (Object)listDataObject.get(0).toJson());
        Assert.assertEquals((Object)new JsonObject().put("foo", (Object)"String 2").put("bar", (Object)2).put("wibble", (Object)2.2), (Object)listDataObject.get(1).toJson());
        Assert.assertEquals(Arrays.asList(TestEnum.JULIEN, TestEnum.TIM), new ArrayList<TestEnum>(listEnum));
        Assert.assertEquals((long)6L, (long)listObject.size());
        Assert.assertEquals((Object)"foo", (Object)listObject.get(0));
        Assert.assertEquals((long)4L, (long)((Number)listObject.get(1)).intValue());
        Assert.assertEquals((double)3.4f, (double)((Number)listObject.get(2)).floatValue(), (double)0.1);
        Assert.assertEquals((Object)true, (Object)listObject.get(3));
        Assert.assertEquals((Object)new JsonObject().put("wibble", (Object)"eek"), (Object)listObject.get(4));
        Assert.assertEquals((Object)new JsonArray().add((Object)"one").add((Object)2), (Object)listObject.get(5));
    }

    @Override
    public void methodWithSetParams(Set<String> setString, Set<Byte> setByte, Set<Short> setShort, Set<Integer> setInt, Set<Long> setLong, Set<JsonObject> setJsonObject, Set<JsonArray> setJsonArray, Set<RefedInterface1> setVertxGen, Set<TestDataObject> setDataObject, Set<TestEnum> setEnum, Set<Object> setObject) {
        Assert.assertTrue((boolean)setString.contains("foo"));
        Assert.assertTrue((boolean)setString.contains("bar"));
        Assert.assertTrue((boolean)setByte.contains((byte)2));
        Assert.assertTrue((boolean)setByte.contains((byte)3));
        Assert.assertTrue((boolean)setShort.contains((short)12));
        Assert.assertTrue((boolean)setShort.contains((short)13));
        Assert.assertTrue((boolean)setInt.contains(1234));
        Assert.assertTrue((boolean)setInt.contains(1345));
        Assert.assertTrue((boolean)setLong.contains(123L));
        Assert.assertTrue((boolean)setLong.contains(456L));
        Assert.assertTrue((boolean)setJsonObject.contains(new JsonObject().put("foo", (Object)"bar")));
        Assert.assertTrue((boolean)setJsonObject.contains(new JsonObject().put("eek", (Object)"wibble")));
        Assert.assertTrue((boolean)setJsonArray.contains(new JsonArray().add((Object)"foo")));
        Assert.assertTrue((boolean)setJsonArray.contains(new JsonArray().add((Object)"blah")));
        Assert.assertTrue((boolean)setVertxGen.contains(new RefedInterface1Impl().setString("foo")));
        Assert.assertTrue((boolean)setVertxGen.contains(new RefedInterface1Impl().setString("bar")));
        Assert.assertEquals((long)2L, (long)setDataObject.size());
        Set setDataObjectJson = setDataObject.stream().map(d -> d.toJson()).collect(Collectors.toSet());
        Assert.assertTrue((boolean)setDataObjectJson.contains(new JsonObject().put("foo", (Object)"String 1").put("bar", (Object)1).put("wibble", (Object)1.1)));
        Assert.assertTrue((boolean)setDataObjectJson.contains(new JsonObject().put("foo", (Object)"String 2").put("bar", (Object)2).put("wibble", (Object)2.2)));
        Assert.assertEquals((long)2L, (long)setEnum.size());
        Assert.assertTrue((boolean)setEnum.contains((Object)TestEnum.JULIEN));
        Assert.assertTrue((boolean)setEnum.contains((Object)TestEnum.TIM));
        Assert.assertEquals((long)6L, (long)setObject.size());
        Assert.assertTrue((boolean)setObject.contains("foo"));
        Assert.assertTrue((boolean)setObject.contains(true));
        Assert.assertTrue((boolean)setObject.contains(true));
        Assert.assertTrue((boolean)setObject.contains(new JsonObject().put("wibble", (Object)"eek")));
        Assert.assertTrue((boolean)setObject.contains(new JsonArray().add((Object)"one").add((Object)2)));
    }

    @Override
    public void methodWithMapParams(Map<String, String> mapString, Map<String, Byte> mapByte, Map<String, Short> mapShort, Map<String, Integer> mapInt, Map<String, Long> mapLong, Map<String, JsonObject> mapJsonObject, Map<String, JsonArray> mapJsonArray, Map<String, RefedInterface1> mapVertxGen, Map<String, TestDataObject> mapDataObject, Map<String, TestEnum> mapEnum, Map<String, Object> mapObject) {
        Assert.assertEquals((Object)"bar", (Object)mapString.get("foo"));
        Assert.assertEquals((Object)"wibble", (Object)mapString.get("eek"));
        Assert.assertEquals((long)2L, (long)mapByte.get("foo").byteValue());
        Assert.assertEquals((long)3L, (long)mapByte.get("eek").byteValue());
        Assert.assertEquals((long)12L, (long)mapShort.get("foo").shortValue());
        Assert.assertEquals((long)13L, (long)mapShort.get("eek").shortValue());
        Assert.assertEquals((long)1234L, (long)mapInt.get("foo").intValue());
        Assert.assertEquals((long)1345L, (long)mapInt.get("eek").intValue());
        Assert.assertEquals((long)123L, (long)mapLong.get("foo"));
        Assert.assertEquals((long)456L, (long)mapLong.get("eek"));
        Assert.assertEquals((Object)new JsonObject().put("foo", (Object)"bar"), (Object)mapJsonObject.get("foo"));
        Assert.assertEquals((Object)new JsonObject().put("eek", (Object)"wibble"), (Object)mapJsonObject.get("eek"));
        Assert.assertEquals((Object)new JsonArray().add((Object)"foo"), (Object)mapJsonArray.get("foo"));
        Assert.assertEquals((Object)new JsonArray().add((Object)"blah"), (Object)mapJsonArray.get("eek"));
        Assert.assertEquals((Object)new RefedInterface1Impl().setString("foo"), (Object)mapVertxGen.get("foo"));
        Assert.assertEquals((Object)new RefedInterface1Impl().setString("bar"), (Object)mapVertxGen.get("eek"));
        Assert.assertEquals((Object)"foo", (Object)mapObject.get("string"));
        Assert.assertEquals((long)4L, (long)((Number)mapObject.get("integer")).intValue());
        Assert.assertEquals((double)3.4f, (double)((Number)mapObject.get("float")).floatValue(), (double)0.1);
        Assert.assertEquals((Object)true, (Object)mapObject.get("boolean"));
        Assert.assertEquals((Object)new TestDataObject().setFoo("String 1").setBar(1).setWibble(1.1), (Object)mapDataObject.get("foo"));
        Assert.assertEquals((Object)((Object)TestEnum.JULIEN), (Object)((Object)mapEnum.get("foo")));
        Assert.assertEquals((Object)new JsonObject().put("wibble", (Object)"eek"), (Object)mapObject.get("object"));
        Assert.assertEquals((Object)new JsonArray().add((Object)"one").add((Object)2), (Object)mapObject.get("array"));
    }

    @Override
    public void methodWithHandlerListAndSet(Handler<List<String>> listStringHandler, Handler<List<Integer>> listIntHandler, Handler<Set<String>> setStringHandler, Handler<Set<Integer>> setIntHandler) {
        List<String> listString = Arrays.asList("foo", "bar", "wibble");
        List<Integer> listInt = Arrays.asList(5, 12, 100);
        LinkedHashSet<String> setString = new LinkedHashSet<String>(Arrays.asList("foo", "bar", "wibble"));
        LinkedHashSet<Integer> setInt = new LinkedHashSet<Integer>(Arrays.asList(5, 12, 100));
        listStringHandler.handle(listString);
        listIntHandler.handle(listInt);
        setStringHandler.handle(setString);
        setIntHandler.handle(setInt);
    }

    @Override
    public Future<List<String>> methodWithHandlerAsyncResultListString() {
        List<String> listString = Arrays.asList("foo", "bar", "wibble");
        return Future.succeededFuture(listString);
    }

    @Override
    public Future<List<Integer>> methodWithHandlerAsyncResultListInteger() {
        List<Integer> listInt = Arrays.asList(5, 12, 100);
        return Future.succeededFuture(listInt);
    }

    @Override
    public Future<Set<String>> methodWithHandlerAsyncResultSetString() {
        LinkedHashSet<String> setString = new LinkedHashSet<String>(Arrays.asList("foo", "bar", "wibble"));
        return Future.succeededFuture(setString);
    }

    @Override
    public Future<Set<Integer>> methodWithHandlerAsyncResultSetInteger() {
        LinkedHashSet<Integer> setInt = new LinkedHashSet<Integer>(Arrays.asList(5, 12, 100));
        return Future.succeededFuture(setInt);
    }

    @Override
    public void methodWithHandlerListVertxGen(Handler<List<RefedInterface1>> listHandler) {
        List<RefedInterface1> list = Arrays.asList(new RefedInterface1Impl().setString("foo"), new RefedInterface1Impl().setString("bar"));
        listHandler.handle(list);
    }

    @Override
    public void methodWithHandlerSetVertxGen(Handler<Set<RefedInterface1>> setHandler) {
        LinkedHashSet<RefedInterface1> list = new LinkedHashSet<RefedInterface1>(Arrays.asList(new RefedInterface1Impl().setString("foo"), new RefedInterface1Impl().setString("bar")));
        setHandler.handle(list);
    }

    @Override
    public void methodWithHandlerListAbstractVertxGen(Handler<List<RefedInterface2>> listHandler) {
        List<RefedInterface2> list = Arrays.asList(new RefedInterface2Impl().setString("abstractfoo"), new RefedInterface2Impl().setString("abstractbar"));
        listHandler.handle(list);
    }

    @Override
    public void methodWithHandlerSetAbstractVertxGen(Handler<Set<RefedInterface2>> setHandler) {
        LinkedHashSet<RefedInterface2> list = new LinkedHashSet<RefedInterface2>(Arrays.asList(new RefedInterface2Impl().setString("abstractfoo"), new RefedInterface2Impl().setString("abstractbar")));
        setHandler.handle(list);
    }

    @Override
    public void methodWithHandlerListJsonObject(Handler<List<JsonObject>> listHandler) {
        List<JsonObject> list = Arrays.asList(new JsonObject().put("cheese", (Object)"stilton"), new JsonObject().put("socks", (Object)"tartan"));
        listHandler.handle(list);
    }

    @Override
    public void methodWithHandlerListComplexJsonObject(Handler<List<JsonObject>> listHandler) {
        List<JsonObject> list = Arrays.asList(new JsonObject().put("outer", (Object)new JsonObject().put("socks", (Object)"tartan")).put("list", (Object)new JsonArray().add((Object)"yellow").add((Object)"blue")));
        listHandler.handle(list);
    }

    @Override
    public void methodWithHandlerSetJsonObject(Handler<Set<JsonObject>> setHandler) {
        LinkedHashSet<JsonObject> set = new LinkedHashSet<JsonObject>(Arrays.asList(new JsonObject().put("cheese", (Object)"stilton"), new JsonObject().put("socks", (Object)"tartan")));
        setHandler.handle(set);
    }

    @Override
    public void methodWithHandlerSetComplexJsonObject(Handler<Set<JsonObject>> setHandler) {
        LinkedHashSet<JsonObject> set = new LinkedHashSet<JsonObject>(Arrays.asList(new JsonObject().put("outer", (Object)new JsonObject().put("socks", (Object)"tartan")).put("list", (Object)new JsonArray().add((Object)"yellow").add((Object)"blue"))));
        setHandler.handle(set);
    }

    @Override
    public void methodWithHandlerListJsonArray(Handler<List<JsonArray>> listHandler) {
        List<JsonArray> list = Arrays.asList(new JsonArray().add((Object)"green").add((Object)"blue"), new JsonArray().add((Object)"yellow").add((Object)"purple"));
        listHandler.handle(list);
    }

    @Override
    public void methodWithHandlerListComplexJsonArray(Handler<List<JsonArray>> listHandler) {
        List<JsonArray> list = Arrays.asList(new JsonArray().add((Object)new JsonObject().put("foo", (Object)"hello")), new JsonArray().add((Object)new JsonObject().put("bar", (Object)"bye")));
        listHandler.handle(list);
    }

    @Override
    public void methodWithHandlerSetJsonArray(Handler<Set<JsonArray>> listHandler) {
        LinkedHashSet<JsonArray> set = new LinkedHashSet<JsonArray>(Arrays.asList(new JsonArray().add((Object)"green").add((Object)"blue"), new JsonArray().add((Object)"yellow").add((Object)"purple")));
        listHandler.handle(set);
    }

    @Override
    public void methodWithHandlerSetComplexJsonArray(Handler<Set<JsonArray>> setHandler) {
        List<JsonArray> list = Arrays.asList(new JsonArray().add((Object)new JsonObject().put("foo", (Object)"hello")), new JsonArray().add((Object)new JsonObject().put("bar", (Object)"bye")));
        LinkedHashSet<JsonArray> set = new LinkedHashSet<JsonArray>(list);
        setHandler.handle(set);
    }

    @Override
    public void methodWithHandlerListDataObject(Handler<List<TestDataObject>> listHandler) {
        List<TestDataObject> list = Arrays.asList(new TestDataObject().setFoo("String 1").setBar(1).setWibble(1.1), new TestDataObject().setFoo("String 2").setBar(2).setWibble(2.2));
        listHandler.handle(list);
    }

    @Override
    public void methodWithHandlerSetDataObject(Handler<Set<TestDataObject>> setHandler) {
        LinkedHashSet<TestDataObject> set = new LinkedHashSet<TestDataObject>(Arrays.asList(new TestDataObject().setFoo("String 1").setBar(1).setWibble(1.1), new TestDataObject().setFoo("String 2").setBar(2).setWibble(2.2)));
        setHandler.handle(set);
    }

    @Override
    public void methodWithHandlerListEnum(Handler<List<TestEnum>> listHandler) {
        listHandler.handle(Arrays.asList(TestEnum.TIM, TestEnum.JULIEN));
    }

    @Override
    public void methodWithHandlerSetEnum(Handler<Set<TestEnum>> setHandler) {
        setHandler.handle(new LinkedHashSet<TestEnum>(Arrays.asList(TestEnum.TIM, TestEnum.JULIEN)));
    }

    @Override
    public Future<List<RefedInterface1>> methodWithHandlerAsyncResultListVertxGen() {
        List<RefedInterface1> list = Arrays.asList(new RefedInterface1Impl().setString("foo"), new RefedInterface1Impl().setString("bar"));
        return Future.succeededFuture(list);
    }

    @Override
    public Future<Set<RefedInterface1>> methodWithHandlerAsyncResultSetVertxGen() {
        LinkedHashSet<RefedInterface1> list = new LinkedHashSet<RefedInterface1>(Arrays.asList(new RefedInterface1Impl().setString("foo"), new RefedInterface1Impl().setString("bar")));
        return Future.succeededFuture(list);
    }

    @Override
    public Future<List<RefedInterface2>> methodWithHandlerAsyncResultListAbstractVertxGen() {
        List<RefedInterface2> list = Arrays.asList(new RefedInterface2Impl().setString("abstractfoo"), new RefedInterface2Impl().setString("abstractbar"));
        return Future.succeededFuture(list);
    }

    @Override
    public Future<Set<RefedInterface2>> methodWithHandlerAsyncResultSetAbstractVertxGen() {
        LinkedHashSet<RefedInterface2> list = new LinkedHashSet<RefedInterface2>(Arrays.asList(new RefedInterface2Impl().setString("abstractfoo"), new RefedInterface2Impl().setString("abstractbar")));
        return Future.succeededFuture(list);
    }

    @Override
    public Future<List<JsonObject>> methodWithHandlerAsyncResultListJsonObject() {
        List<JsonObject> list = Arrays.asList(new JsonObject().put("cheese", (Object)"stilton"), new JsonObject().put("socks", (Object)"tartan"));
        return Future.succeededFuture(list);
    }

    @Override
    public Future<List<JsonObject>> methodWithHandlerAsyncResultListComplexJsonObject() {
        List<JsonObject> list = Arrays.asList(new JsonObject().put("outer", (Object)new JsonObject().put("socks", (Object)"tartan")).put("list", (Object)new JsonArray().add((Object)"yellow").add((Object)"blue")));
        return Future.succeededFuture(list);
    }

    @Override
    public Future<Set<JsonObject>> methodWithHandlerAsyncResultSetJsonObject() {
        LinkedHashSet<JsonObject> set = new LinkedHashSet<JsonObject>(Arrays.asList(new JsonObject().put("cheese", (Object)"stilton"), new JsonObject().put("socks", (Object)"tartan")));
        return Future.succeededFuture(set);
    }

    @Override
    public Future<Set<JsonObject>> methodWithHandlerAsyncResultSetComplexJsonObject() {
        LinkedHashSet<JsonObject> set = new LinkedHashSet<JsonObject>(Arrays.asList(new JsonObject().put("outer", (Object)new JsonObject().put("socks", (Object)"tartan")).put("list", (Object)new JsonArray().add((Object)"yellow").add((Object)"blue"))));
        return Future.succeededFuture(set);
    }

    @Override
    public Future<List<JsonArray>> methodWithHandlerAsyncResultListJsonArray() {
        List<JsonArray> list = Arrays.asList(new JsonArray().add((Object)"green").add((Object)"blue"), new JsonArray().add((Object)"yellow").add((Object)"purple"));
        return Future.succeededFuture(list);
    }

    @Override
    public Future<List<JsonArray>> methodWithHandlerAsyncResultListComplexJsonArray() {
        List<JsonArray> list = Arrays.asList(new JsonArray().add((Object)new JsonObject().put("foo", (Object)"hello")), new JsonArray().add((Object)new JsonObject().put("bar", (Object)"bye")));
        return Future.succeededFuture(list);
    }

    @Override
    public Future<Set<JsonArray>> methodWithHandlerAsyncResultSetJsonArray() {
        LinkedHashSet<JsonArray> set = new LinkedHashSet<JsonArray>(Arrays.asList(new JsonArray().add((Object)"green").add((Object)"blue"), new JsonArray().add((Object)"yellow").add((Object)"purple")));
        return Future.succeededFuture(set);
    }

    @Override
    public Future<Set<JsonArray>> methodWithHandlerAsyncResultSetComplexJsonArray() {
        LinkedHashSet<JsonArray> set = new LinkedHashSet<JsonArray>(Arrays.asList(new JsonArray().add((Object)new JsonObject().put("foo", (Object)"hello")), new JsonArray().add((Object)new JsonObject().put("bar", (Object)"bye"))));
        return Future.succeededFuture(set);
    }

    @Override
    public Future<List<TestDataObject>> methodWithHandlerAsyncResultListDataObject() {
        List<TestDataObject> list = Arrays.asList(new TestDataObject().setFoo("String 1").setBar(1).setWibble(1.1), new TestDataObject().setFoo("String 2").setBar(2).setWibble(2.2));
        return Future.succeededFuture(list);
    }

    @Override
    public Future<Set<TestDataObject>> methodWithHandlerAsyncResultSetDataObject() {
        LinkedHashSet<TestDataObject> set = new LinkedHashSet<TestDataObject>(Arrays.asList(new TestDataObject().setFoo("String 1").setBar(1).setWibble(1.1), new TestDataObject().setFoo("String 2").setBar(2).setWibble(2.2)));
        return Future.succeededFuture(set);
    }

    @Override
    public Future<List<TestEnum>> methodWithHandlerAsyncResultListEnum() {
        return Future.succeededFuture(Arrays.asList(TestEnum.TIM, TestEnum.JULIEN));
    }

    @Override
    public Future<Set<TestEnum>> methodWithHandlerAsyncResultSetEnum() {
        return Future.succeededFuture(new LinkedHashSet<TestEnum>(Arrays.asList(TestEnum.TIM, TestEnum.JULIEN)));
    }

    @Override
    public List<String> methodWithListStringReturn() {
        return Arrays.asList("foo", "bar", "wibble");
    }

    @Override
    public Set<String> methodWithSetStringReturn() {
        return new LinkedHashSet<String>(Arrays.asList("foo", "bar", "wibble"));
    }

    @Override
    public Map<String, String> methodWithMapStringReturn(Handler<String> handler) {
        StringHandlerTestMap map = new StringHandlerTestMap(handler);
        map.put("foo", "bar");
        return map;
    }

    @Override
    public Map<String, JsonObject> methodWithMapJsonObjectReturn(Handler<String> handler) {
        JsonObjectHandlerTestMap map = new JsonObjectHandlerTestMap(handler);
        map.put("foo", new JsonObject().put("wibble", (Object)"eek"));
        return map;
    }

    @Override
    public Map<String, JsonObject> methodWithMapComplexJsonObjectReturn(Handler<String> handler) {
        JsonObjectHandlerTestMap map = new JsonObjectHandlerTestMap(handler);
        map.put("foo", new JsonObject().put("outer", (Object)new JsonObject().put("socks", (Object)"tartan")).put("list", (Object)new JsonArray().add((Object)"yellow").add((Object)"blue")));
        return map;
    }

    @Override
    public Map<String, JsonArray> methodWithMapJsonArrayReturn(Handler<String> handler) {
        JsonArrayHandlerTestMap map = new JsonArrayHandlerTestMap(handler);
        map.put("foo", new JsonArray().add((Object)"wibble"));
        return map;
    }

    @Override
    public Map<String, JsonArray> methodWithMapComplexJsonArrayReturn(Handler<String> handler) {
        JsonArrayHandlerTestMap map = new JsonArrayHandlerTestMap(handler);
        map.put("foo", new JsonArray().add((Object)new JsonObject().put("foo", (Object)"hello")).add((Object)new JsonObject().put("bar", (Object)"bye")));
        return map;
    }

    @Override
    public Map<String, Object> methodWithMapObjectReturn(Handler<String> handler) {
        ObjectHandlerTestMap map = new ObjectHandlerTestMap(handler);
        map.put("string", "foo");
        map.put("integer", Integer.valueOf(4));
        map.put("float", Float.valueOf(3.4f));
        map.put("object", new JsonObject().put("wibble", (Object)"eek"));
        map.put("array", new JsonArray().add((Object)"one").add((Object)2));
        map.put("boolean", Boolean.valueOf(true));
        return map;
    }

    @Override
    public Map<String, Long> methodWithMapLongReturn(Handler<String> handler) {
        LongHandlerTestMap map = new LongHandlerTestMap(handler);
        map.put("foo", Long.valueOf(123L));
        return map;
    }

    @Override
    public Map<String, Integer> methodWithMapIntegerReturn(Handler<String> handler) {
        IntegerHandlerTestMap map = new IntegerHandlerTestMap(handler);
        map.put("foo", Integer.valueOf(123));
        return map;
    }

    @Override
    public Map<String, Short> methodWithMapShortReturn(Handler<String> handler) {
        ShortHandlerTestMap map = new ShortHandlerTestMap(handler);
        map.put("foo", Short.valueOf((short)123));
        return map;
    }

    @Override
    public Map<String, Byte> methodWithMapByteReturn(Handler<String> handler) {
        ByteHandlerTestMap map = new ByteHandlerTestMap(handler);
        map.put("foo", Byte.valueOf((byte)123));
        return map;
    }

    @Override
    public Map<String, Character> methodWithMapCharacterReturn(Handler<String> handler) {
        CharacterHandlerTestMap map = new CharacterHandlerTestMap(handler);
        map.put("foo", Character.valueOf('X'));
        return map;
    }

    @Override
    public Map<String, Boolean> methodWithMapBooleanReturn(Handler<String> handler) {
        BooleanHandlerTestMap map = new BooleanHandlerTestMap(handler);
        map.put("foo", Boolean.valueOf(true));
        return map;
    }

    @Override
    public Map<String, Float> methodWithMapFloatReturn(Handler<String> handler) {
        FloatHandlerTestMap map = new FloatHandlerTestMap(handler);
        map.put("foo", Float.valueOf(0.123f));
        return map;
    }

    @Override
    public Map<String, Double> methodWithMapDoubleReturn(Handler<String> handler) {
        DoubleHandlerTestMap map = new DoubleHandlerTestMap(handler);
        map.put("foo", Double.valueOf(0.123));
        return map;
    }

    @Override
    public Map<String, RefedInterface1> methodWithMapVertxGenReturn(Handler<String> handler) {
        VertxGenHandlerTestMap map = new VertxGenHandlerTestMap(handler);
        map.put("foo", new RefedInterface1Impl().setString("foo"));
        return map;
    }

    @Override
    public Map<String, TestDataObject> methodWithMapDataObjectReturn(Handler<String> handler) {
        DataObjectHandlerTestMap map = new DataObjectHandlerTestMap(handler);
        map.put("foo", new TestDataObject().setFoo("String 1").setBar(1).setWibble(1.1));
        return map;
    }

    @Override
    public Map<String, TestEnum> methodWithMapEnumReturn(Handler<String> handler) {
        EnumHandlerTestMap map = new EnumHandlerTestMap(handler);
        map.put("foo", TestEnum.JULIEN);
        return map;
    }

    @Override
    public List<Long> methodWithListLongReturn() {
        return Arrays.asList(123L, 456L);
    }

    @Override
    public List<RefedInterface1> methodWithListVertxGenReturn() {
        return Arrays.asList(new RefedInterface1Impl().setString("foo"), new RefedInterface1Impl().setString("bar"));
    }

    @Override
    public List<JsonObject> methodWithListJsonObjectReturn() {
        return Arrays.asList(new JsonObject().put("foo", (Object)"bar"), new JsonObject().put("blah", (Object)"eek"));
    }

    @Override
    public List<JsonObject> methodWithListComplexJsonObjectReturn() {
        return Arrays.asList(new JsonObject().put("outer", (Object)new JsonObject().put("socks", (Object)"tartan")).put("list", (Object)new JsonArray().add((Object)"yellow").add((Object)"blue")));
    }

    @Override
    public List<JsonArray> methodWithListJsonArrayReturn() {
        return Arrays.asList(new JsonArray().add((Object)"foo"), new JsonArray().add((Object)"blah"));
    }

    @Override
    public List<JsonArray> methodWithListComplexJsonArrayReturn() {
        return Arrays.asList(new JsonArray().add((Object)new JsonObject().put("foo", (Object)"hello")), new JsonArray().add((Object)new JsonObject().put("bar", (Object)"bye")));
    }

    @Override
    public List<TestDataObject> methodWithListDataObjectReturn() {
        return Arrays.asList(new TestDataObject().setFoo("String 1").setBar(1).setWibble(1.1), new TestDataObject().setFoo("String 2").setBar(2).setWibble(2.2));
    }

    @Override
    public List<TestEnum> methodWithListEnumReturn() {
        return Arrays.asList(TestEnum.JULIEN, TestEnum.TIM);
    }

    @Override
    public List<Object> methodWithListObjectReturn() {
        return Arrays.asList("foo", 4, Float.valueOf(3.4f), true, new JsonObject().put("wibble", (Object)"eek"), new JsonArray().add((Object)"one").add((Object)2));
    }

    @Override
    public Set<Long> methodWithSetLongReturn() {
        return new LinkedHashSet<Long>(Arrays.asList(123L, 456L));
    }

    @Override
    public Set<RefedInterface1> methodWithSetVertxGenReturn() {
        return new LinkedHashSet<RefedInterface1>(Arrays.asList(new RefedInterface1Impl().setString("foo"), new RefedInterface1Impl().setString("bar")));
    }

    @Override
    public Set<JsonObject> methodWithSetJsonObjectReturn() {
        return new LinkedHashSet<JsonObject>(Arrays.asList(new JsonObject().put("foo", (Object)"bar"), new JsonObject().put("blah", (Object)"eek")));
    }

    @Override
    public Set<JsonObject> methodWithSetComplexJsonObjectReturn() {
        return new LinkedHashSet<JsonObject>(Arrays.asList(new JsonObject().put("outer", (Object)new JsonObject().put("socks", (Object)"tartan")).put("list", (Object)new JsonArray().add((Object)"yellow").add((Object)"blue"))));
    }

    @Override
    public Set<JsonArray> methodWithSetJsonArrayReturn() {
        return new LinkedHashSet<JsonArray>(Arrays.asList(new JsonArray().add((Object)"foo"), new JsonArray().add((Object)"blah")));
    }

    @Override
    public Set<JsonArray> methodWithSetComplexJsonArrayReturn() {
        return new LinkedHashSet<JsonArray>(Arrays.asList(new JsonArray().add((Object)new JsonObject().put("foo", (Object)"hello")), new JsonArray().add((Object)new JsonObject().put("bar", (Object)"bye"))));
    }

    @Override
    public Set<TestDataObject> methodWithSetDataObjectReturn() {
        return new LinkedHashSet<TestDataObject>(this.methodWithListDataObjectReturn());
    }

    @Override
    public Set<TestEnum> methodWithSetEnumReturn() {
        return new LinkedHashSet<TestEnum>(this.methodWithListEnumReturn());
    }

    @Override
    public Set<Object> methodWithSetObjectReturn() {
        return new LinkedHashSet<Object>(this.methodWithListObjectReturn());
    }

    static class EnumHandlerTestMap
    extends HandlerTestMap<TestEnum> {
        public EnumHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public TestEnum put(String key, TestEnum value) {
            return super.put(key, value);
        }
    }

    static class DataObjectHandlerTestMap
    extends HandlerTestMap<TestDataObject> {
        public DataObjectHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public TestDataObject put(String key, TestDataObject value) {
            return super.put(key, value);
        }
    }

    static class VertxGenHandlerTestMap
    extends HandlerTestMap<RefedInterface1> {
        public VertxGenHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public RefedInterface1 put(String key, RefedInterface1 value) {
            return super.put(key, value);
        }
    }

    static class DoubleHandlerTestMap
    extends HandlerTestMap<Double> {
        public DoubleHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public Double put(String key, Double value) {
            return super.put(key, value);
        }
    }

    private static class BooleanHandlerTestMap
    extends HandlerTestMap<Boolean> {
        public BooleanHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public Boolean put(String key, Boolean value) {
            return super.put(key, value);
        }
    }

    private static class StringHandlerTestMap
    extends HandlerTestMap<String> {
        public StringHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public String put(String key, String value) {
            return super.put(key, value);
        }
    }

    private static class JsonObjectHandlerTestMap
    extends HandlerTestMap<JsonObject> {
        public JsonObjectHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public JsonObject put(String key, JsonObject value) {
            return super.put(key, value);
        }
    }

    private static class ObjectHandlerTestMap
    extends HandlerTestMap<Object> {
        public ObjectHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public Object put(String key, Object value) {
            return super.put(key, value);
        }
    }

    private static class JsonArrayHandlerTestMap
    extends HandlerTestMap<JsonArray> {
        public JsonArrayHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public JsonArray put(String key, JsonArray value) {
            return super.put(key, value);
        }
    }

    private static class LongHandlerTestMap
    extends HandlerTestMap<Long> {
        public LongHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public Long put(String key, Long value) {
            return super.put(key, value);
        }
    }

    private static class ShortHandlerTestMap
    extends HandlerTestMap<Short> {
        public ShortHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public Short put(String key, Short value) {
            return super.put(key, value);
        }
    }

    private static class IntegerHandlerTestMap
    extends HandlerTestMap<Integer> {
        public IntegerHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public Integer put(String key, Integer value) {
            return super.put(key, value);
        }
    }

    private static class ByteHandlerTestMap
    extends HandlerTestMap<Byte> {
        public ByteHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public Byte put(String key, Byte value) {
            return super.put(key, value);
        }
    }

    private static class CharacterHandlerTestMap
    extends HandlerTestMap<Character> {
        public CharacterHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public Character put(String key, Character value) {
            return super.put(key, value);
        }
    }

    private static class FloatHandlerTestMap
    extends HandlerTestMap<Float> {
        public FloatHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public Float put(String key, Float value) {
            return super.put(key, value);
        }
    }

    private static class HandlerTestMap<V>
    implements Map<String, V> {
        private Handler<String> handler;
        private Map<String, V> map = new HashMap<String, V>();

        private HandlerTestMap(Handler<String> handler) {
            this.handler = handler;
        }

        @Override
        public int size() {
            this.handler.handle((Object)"size()");
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            this.handler.handle((Object)"isEmpty()");
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            this.handler.handle((Object)("containsKey(" + String.valueOf(key) + ")"));
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            this.handler.handle((Object)("containsValue(" + String.valueOf(value) + ")"));
            return this.map.containsValue(value);
        }

        @Override
        public V get(Object key) {
            this.handler.handle((Object)("get(" + String.valueOf(key) + ")"));
            return this.map.get(key);
        }

        @Override
        public V put(String key, V value) {
            this.handler.handle((Object)("put(" + key + "," + String.valueOf(value) + ")"));
            return this.map.put(key, value);
        }

        @Override
        public V remove(Object key) {
            this.handler.handle((Object)("remove(" + String.valueOf(key) + ")"));
            return this.map.remove(key);
        }

        @Override
        public void putAll(Map<? extends String, ? extends V> m) {
            this.handler.handle((Object)"putAll(m)");
            this.map.putAll(m);
        }

        @Override
        public void clear() {
            this.handler.handle((Object)"clear()");
            this.map.clear();
        }

        @Override
        public Set<String> keySet() {
            this.handler.handle((Object)"keySet()");
            return this.map.keySet();
        }

        @Override
        public Collection<V> values() {
            this.handler.handle((Object)"values()");
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<String, V>> entrySet() {
            this.handler.handle((Object)"entrySet()");
            return this.map.entrySet();
        }
    }
}

