/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.testmodel;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.testmodel.MyPojoToInteger;
import io.vertx.codegen.testmodel.MyPojoToJsonArray;
import io.vertx.codegen.testmodel.MyPojoToJsonObject;
import io.vertx.codegen.testmodel.TestCustomEnum;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@VertxGen
public interface JsonMapperTCK {
    @GenIgnore
    public static Integer serializeMyPojoToInteger(MyPojoToInteger value) {
        return value.getA();
    }

    @GenIgnore
    public static MyPojoToInteger deserializeMyPojoToInteger(Integer value) {
        return new MyPojoToInteger(value);
    }

    @GenIgnore
    public static JsonObject serializeMyPojoToJsonObject(MyPojoToJsonObject value) {
        return new JsonObject().put("v", (Object)value.getV());
    }

    @GenIgnore
    public static MyPojoToJsonObject deserializeMyPojoToJsonObject(JsonObject value) {
        return new MyPojoToJsonObject(value.getInteger("v"));
    }

    @GenIgnore
    public static JsonArray serializeMyPojoToJsonArray(MyPojoToJsonArray value) {
        return new JsonArray(value.stuff);
    }

    @GenIgnore
    public static MyPojoToJsonArray deserializeMyPojoToJsonArray(JsonArray value) {
        return new MyPojoToJsonArray(value.stream().map(j -> (Integer)j).collect(Collectors.toList()));
    }

    @GenIgnore
    public static String serializeZonedDateTime(ZonedDateTime value) {
        return value.toString();
    }

    @GenIgnore
    public static ZonedDateTime deserializeZonedDateTime(String value) {
        return ZonedDateTime.parse(value);
    }

    @GenIgnore
    public static String serializeCustomEnum(TestCustomEnum value) {
        return value != null ? value.getShortName() : null;
    }

    @GenIgnore
    public static TestCustomEnum deserializeCustomEnum(String value) {
        return value != null ? TestCustomEnum.of(value) : null;
    }

    public void methodWithTypeToIntegerParam(MyPojoToInteger var1);

    public void methodWithListOfTypeToIntegerParam(List<MyPojoToInteger> var1);

    public void methodWithSetOfTypeToIntegerParam(Set<MyPojoToInteger> var1);

    public void methodWithMapOfTypeToIntegerParam(Map<String, MyPojoToInteger> var1);

    public MyPojoToInteger methodWithTypeToIntegerReturn();

    public List<MyPojoToInteger> methodWithListOfTypeToIntegerReturn();

    public Set<MyPojoToInteger> methodWithSetOfTypeToIntegerReturn();

    public Map<String, MyPojoToInteger> methodWithMapOfTypeToIntegerReturn();

    public void methodWithHandlerTypeToIntegerParam(Handler<MyPojoToInteger> var1);

    public void methodWithHandlerListOfTypeToIntegerParam(Handler<List<MyPojoToInteger>> var1);

    public void methodWithHandlerSetOfTypeToIntegerParam(Handler<Set<MyPojoToInteger>> var1);

    public void methodWithHandlerMapOfTypeToIntegerParam(Handler<Map<String, MyPojoToInteger>> var1);

    public Future<MyPojoToInteger> methodWithHandlerAsyncResultTypeToIntegerParam();

    public Future<List<MyPojoToInteger>> methodWithHandlerAsyncResultListOfTypeToIntegerParam();

    public Future<Set<MyPojoToInteger>> methodWithHandlerAsyncResultSetOfTypeToIntegerParam();

    public Future<Map<String, MyPojoToInteger>> methodWithHandlerAsyncResultMapOfTypeToIntegerParam();

    public void methodWithTypeToStringParam(ZonedDateTime var1);

    public void methodWithListOfTypeToStringParam(List<ZonedDateTime> var1);

    public void methodWithSetOfTypeToStringParam(Set<ZonedDateTime> var1);

    public void methodWithMapOfTypeToStringParam(Map<String, ZonedDateTime> var1);

    public ZonedDateTime methodWithTypeToStringReturn();

    public List<ZonedDateTime> methodWithListOfTypeToStringReturn();

    public Set<ZonedDateTime> methodWithSetOfTypeToStringReturn();

    public Map<String, ZonedDateTime> methodWithMapOfTypeToStringReturn();

    public void methodWithHandlerTypeToStringParam(Handler<ZonedDateTime> var1);

    public void methodWithHandlerListOfTypeToStringParam(Handler<List<ZonedDateTime>> var1);

    public void methodWithHandlerSetOfTypeToStringParam(Handler<Set<ZonedDateTime>> var1);

    public void methodWithHandlerMapOfTypeToStringParam(Handler<Map<String, ZonedDateTime>> var1);

    public Future<ZonedDateTime> methodWithHandlerAsyncResultTypeToStringParam();

    public Future<List<ZonedDateTime>> methodWithHandlerAsyncResultListOfTypeToStringParam();

    public Future<Set<ZonedDateTime>> methodWithHandlerAsyncResultSetOfTypeToStringParam();

    public Future<Map<String, ZonedDateTime>> methodWithHandlerAsyncResultMapOfTypeToStringParam();

    public void methodWithTypeToJsonArrayParam(MyPojoToJsonArray var1);

    public void methodWithListOfTypeToJsonArrayParam(List<MyPojoToJsonArray> var1);

    public void methodWithSetOfTypeToJsonArrayParam(Set<MyPojoToJsonArray> var1);

    public void methodWithMapOfTypeToJsonArrayParam(Map<String, MyPojoToJsonArray> var1);

    public MyPojoToJsonArray methodWithTypeToJsonArrayReturn();

    public List<MyPojoToJsonArray> methodWithListOfTypeToJsonArrayReturn();

    public Set<MyPojoToJsonArray> methodWithSetOfTypeToJsonArrayReturn();

    public Map<String, MyPojoToJsonArray> methodWithMapOfTypeToJsonArrayReturn();

    public void methodWithHandlerTypeToJsonArrayParam(Handler<MyPojoToJsonArray> var1);

    public void methodWithHandlerListOfTypeToJsonArrayParam(Handler<List<MyPojoToJsonArray>> var1);

    public void methodWithHandlerSetOfTypeToJsonArrayParam(Handler<Set<MyPojoToJsonArray>> var1);

    public void methodWithHandlerMapOfTypeToJsonArrayParam(Handler<Map<String, MyPojoToJsonArray>> var1);

    public Future<MyPojoToJsonArray> methodWithHandlerAsyncResultTypeToJsonArrayParam();

    public Future<List<MyPojoToJsonArray>> methodWithHandlerAsyncResultListOfTypeToJsonArrayParam();

    public Future<Set<MyPojoToJsonArray>> methodWithHandlerAsyncResultSetOfTypeToJsonArrayParam();

    public Future<Map<String, MyPojoToJsonArray>> methodWithHandlerAsyncResultMapOfTypeToJsonArrayParam();

    public void methodWithTypeToJsonObjectParam(MyPojoToJsonObject var1);

    public void methodWithListOfTypeToJsonObjectParam(List<MyPojoToJsonObject> var1);

    public void methodWithSetOfTypeToJsonObjectParam(Set<MyPojoToJsonObject> var1);

    public void methodWithMapOfTypeToJsonObjectParam(Map<String, MyPojoToJsonObject> var1);

    public MyPojoToJsonObject methodWithTypeToJsonObjectReturn();

    public List<MyPojoToJsonObject> methodWithListOfTypeToJsonObjectReturn();

    public Set<MyPojoToJsonObject> methodWithSetOfTypeToJsonObjectReturn();

    public Map<String, MyPojoToJsonObject> methodWithMapOfTypeToJsonObjectReturn();

    public void methodWithHandlerTypeToJsonObjectParam(Handler<MyPojoToJsonObject> var1);

    public void methodWithHandlerListOfTypeToJsonObjectParam(Handler<List<MyPojoToJsonObject>> var1);

    public void methodWithHandlerSetOfTypeToJsonObjectParam(Handler<Set<MyPojoToJsonObject>> var1);

    public void methodWithHandlerMapOfTypeToJsonObjectParam(Handler<Map<String, MyPojoToJsonObject>> var1);

    public Future<MyPojoToJsonObject> methodWithHandlerAsyncResultTypeToJsonObjectParam();

    public Future<List<MyPojoToJsonObject>> methodWithHandlerAsyncResultListOfTypeToJsonObjectParam();

    public Future<Set<MyPojoToJsonObject>> methodWithHandlerAsyncResultSetOfTypeToJsonObjectParam();

    public Future<Map<String, MyPojoToJsonObject>> methodWithHandlerAsyncResultMapOfTypeToJsonObjectParam();

    public void methodWithCustomEnumToStringParam(TestCustomEnum var1);

    public void methodWithListOfCustomEnumToStringParam(List<TestCustomEnum> var1);

    public void methodWithSetOfCustomEnumToStringParam(Set<TestCustomEnum> var1);

    public void methodWithMapOfCustomEnumToStringParam(Map<String, TestCustomEnum> var1);

    public TestCustomEnum methodWithCustomEnumToStringReturn();

    public List<TestCustomEnum> methodWithListOfCustomEnumToStringReturn();

    public Set<TestCustomEnum> methodWithSetOfCustomEnumToStringReturn();

    public Map<String, TestCustomEnum> methodWithMapOfCustomEnumToStringReturn();

    public void methodWithHandlerCustomEnumToStringParam(Handler<TestCustomEnum> var1);

    public void methodWithHandlerListOfCustomEnumToStringParam(Handler<List<TestCustomEnum>> var1);

    public void methodWithHandlerSetOfCustomEnumToStringParam(Handler<Set<TestCustomEnum>> var1);

    public void methodWithHandlerMapOfCustomEnumToStringParam(Handler<Map<String, TestCustomEnum>> var1);

    public Future<TestCustomEnum> methodWithHandlerAsyncResultCustomEnumToStringParam();

    public Future<List<TestCustomEnum>> methodWithHandlerAsyncResultListOfCustomEnumToStringParam();

    public Future<Set<TestCustomEnum>> methodWithHandlerAsyncResultSetOfCustomEnumToStringParam();

    public Future<Map<String, TestCustomEnum>> methodWithHandlerAsyncResultMapOfCustomEnumToStringParam();
}

