/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.testmodel;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.testmodel.GenericRefedInterface;
import io.vertx.codegen.testmodel.GenericRefedInterfaceImpl;
import io.vertx.codegen.testmodel.SupplierParamTCK;
import io.vertx.codegen.testmodel.TestDataObject;
import io.vertx.codegen.testmodel.TestEnum;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.junit.Assert;

public class SupplierParamTCKImpl
implements SupplierParamTCK {
    @Override
    public String methodWithBasicReturn(Supplier<Byte> byteFunc, Supplier<Short> shortFunc, Supplier<Integer> integerFunc, Supplier<Long> longFunc, Supplier<Float> floatFunc, Supplier<Double> doubleFunc, Supplier<Boolean> booleanFunc, Supplier<Character> charFunc, Supplier<String> stringFunc) {
        Assert.assertEquals((long)10L, (long)byteFunc.get().byteValue());
        Assert.assertEquals((long)1000L, (long)shortFunc.get().shortValue());
        Assert.assertEquals((long)100000L, (long)integerFunc.get().intValue());
        Assert.assertEquals((long)10000000000L, (long)longFunc.get());
        Assert.assertEquals((double)0.01f, (double)floatFunc.get().floatValue(), (double)0.001);
        Assert.assertEquals((double)1.0E-5, (double)doubleFunc.get(), (double)1.0E-6);
        Assert.assertEquals((Object)true, (Object)booleanFunc.get());
        Assert.assertEquals((long)67L, (long)charFunc.get().charValue());
        Assert.assertEquals((Object)"the-return", (Object)stringFunc.get());
        return "ok";
    }

    @Override
    public String methodWithJsonReturn(Supplier<JsonObject> objectFunc, Supplier<JsonArray> arrayFunc) {
        Assert.assertEquals((Object)new JsonObject().put("foo", (Object)"foo_value").put("bar", (Object)10).put("wibble", (Object)0.1), (Object)objectFunc.get());
        Assert.assertEquals((Object)new JsonArray().add((Object)"one").add((Object)"two").add((Object)"three"), (Object)arrayFunc.get());
        return "ok";
    }

    @Override
    public String methodWithObjectReturn(Supplier<Object> func) {
        Assert.assertEquals((Object)"the-string", (Object)func.get());
        Assert.assertEquals((long)123L, (long)((Number)func.get()).intValue());
        Assert.assertEquals((Object)true, (Object)func.get());
        Assert.assertEquals((Object)new JsonObject().put("foo", (Object)"foo_value"), (Object)func.get());
        Assert.assertEquals((Object)new JsonArray().add((Object)"foo").add((Object)"bar"), (Object)func.get());
        return "ok";
    }

    @Override
    public String methodWithDataObjectReturn(Supplier<TestDataObject> func) {
        TestDataObject val = func.get();
        Assert.assertEquals((Object)"wasabi", (Object)val.getFoo());
        Assert.assertEquals((long)6L, (long)val.getBar());
        Assert.assertEquals((double)0.01, (double)val.getWibble(), (double)0.001);
        return "ok";
    }

    @Override
    public String methodWithEnumReturn(Supplier<TestEnum> func) {
        Assert.assertEquals((Object)((Object)TestEnum.NICK), (Object)((Object)func.get()));
        return "ok";
    }

    @Override
    public String methodWithListReturn(Supplier<List<String>> func) {
        Assert.assertEquals(Arrays.asList("one", "two", "three"), func.get());
        return "ok";
    }

    @Override
    public String methodWithSetReturn(Supplier<Set<String>> func) {
        Assert.assertEquals(new HashSet<String>(Arrays.asList("one", "two", "three")), func.get());
        return "ok";
    }

    @Override
    public String methodWithMapReturn(Supplier<Map<String, String>> func) {
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("one", "one");
        expected.put("two", "two");
        expected.put("three", "three");
        Assert.assertEquals(expected, func.get());
        return "ok";
    }

    @Override
    public <T> String methodWithGenericReturn(Supplier<T> func) {
        return this.methodWithObjectReturn(func::get);
    }

    @Override
    public <T> String methodWithGenericUserTypeReturn(Supplier<GenericRefedInterface<T>> func) {
        GenericRefedInterfaceImpl impl = new GenericRefedInterfaceImpl();
        Assert.assertEquals(impl, func.get());
        return "ok";
    }

    @Override
    public String methodWithNullableListReturn(Supplier<@Nullable List<String>> func) {
        Assert.assertEquals(null, func.get());
        return "ok";
    }
}

