/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it;

import io.vertx.core.file.OpenOptions;
import io.vertx.rxjava.core.Vertx;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.file.AsyncFile;
import io.vertx.test.core.Repeat;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import java.io.File;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Test;
import rx.Completable;
import rx.CompletableSubscriber;
import rx.Observable;
import rx.Subscriber;

public class AsyncFileTest
extends VertxTestBase {
    private Vertx vertx;

    public void setUp() throws Exception {
        super.setUp();
        this.vertx = new Vertx(((VertxTestBase)this).vertx);
    }

    @Test
    @Repeat(times=100)
    public void observableToAsyncFile() throws Exception {
        this.sourceToAsyncFile((flow, asyncFile) -> Completable.create(emitter -> flow.subscribe((Subscriber)asyncFile.toSubscriber().onWriteStreamEnd(() -> ((CompletableSubscriber)emitter).onCompleted()))));
    }

    private void sourceToAsyncFile(BiFunction<Observable<Buffer>, AsyncFile, Completable> func) throws Exception {
        File file = TestUtils.tmpFile((String)"txt");
        this.assertTrue(!file.exists() || file.delete());
        List bytes = IntStream.range(0, 131072).boxed().map(step -> (byte)TestUtils.randomChar()).collect(Collectors.toList());
        Observable flow = Observable.from(bytes).buffer(256).map(ba -> {
            Buffer buffer = Buffer.buffer();
            ba.forEach(arg_0 -> ((Buffer)buffer).appendByte(arg_0));
            return buffer;
        });
        Completable writeToFile = this.vertx.fileSystem().rxOpen(file.toString(), new OpenOptions().setWrite(true)).flatMapCompletable(asyncFile -> (Completable)func.apply((Observable<Buffer>)flow, (AsyncFile)asyncFile));
        writeToFile.andThen(this.vertx.fileSystem().rxReadFile(file.toString())).test().awaitTerminalEvent().assertValue((Object)bytes.stream().collect(Buffer::buffer, Buffer::appendByte, Buffer::appendBuffer));
    }
}

