/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.rxjava.ext.jdbc.JDBCClient;
import io.vertx.test.core.VertxTestBase;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;
import rx.Observable;

public class JDBCClientTest
extends VertxTestBase {
    private static final JsonObject config = new JsonObject().put("url", (Object)"jdbc:hsqldb:mem:test?shutdown=true").put("driver_class", (Object)"org.hsqldb.jdbcDriver");

    @Test
    public void testStreamRX() {
        try (JDBCClient client = new JDBCClient(io.vertx.ext.jdbc.JDBCClient.create((Vertx)this.vertx, (JsonObject)config));){
            client.getConnection(this.onSuccess(conn -> {
                ArrayList<String> SQL = new ArrayList<String>();
                SQL.add("drop table if exists select_table;");
                SQL.add("create table select_table (id int, lname varchar(255), fname varchar(255) );");
                SQL.add("insert into select_table values (1, 'doe', 'john');");
                SQL.add("insert into select_table values (2, 'doe', 'jane');");
                try {
                    for (String sql : SQL) {
                        ((Connection)conn.getDelegate().unwrap()).createStatement().execute(sql);
                    }
                }
                catch (SQLException e) {
                    this.fail(e);
                    return;
                }
                String sql = "SELECT ID, FNAME, LNAME FROM select_table ORDER BY ID";
                conn.queryStream(sql, this.onSuccess(res -> {
                    AtomicInteger cnt = new AtomicInteger(0);
                    Observable observable = res.toObservable();
                    observable.subscribe(row -> {
                        this.assertEquals("doe", row.getString(res.column("lname")));
                        cnt.incrementAndGet();
                    }, arg_0 -> ((JDBCClientTest)this).fail(arg_0), () -> {
                        this.assertEquals(2L, cnt.get());
                        this.testComplete();
                    });
                }));
            }));
            this.await();
        }
    }
}

