/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it;

import com.jayway.awaitility.Awaitility;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.it.MyRXVerticle;
import io.vertx.it.RXHelloServiceConsumer;
import io.vertx.it.service.HelloService;
import io.vertx.it.service.HelloServiceImpl;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.impl.DiscoveryImpl;
import io.vertx.servicediscovery.types.EventBusService;
import io.vertx.servicediscovery.types.HttpEndpoint;
import io.vertx.servicediscovery.types.JDBCDataSource;
import io.vertx.servicediscovery.types.MessageSource;
import io.vertx.servicediscovery.types.MongoDataSource;
import io.vertx.servicediscovery.types.RedisDataSource;
import io.vertx.serviceproxy.ProxyHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class ServiceDiscoveryTest {
    public static final ServiceDiscoveryOptions DISCOVERY_OPTIONS = new ServiceDiscoveryOptions().setBackendConfiguration(new JsonObject().put("backend-name", (Object)"io.vertx.servicediscovery.impl.DefaultServiceDiscoveryBackend"));
    protected Vertx vertx;
    protected ServiceDiscovery discovery;

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
        this.discovery = new DiscoveryImpl(this.vertx, DISCOVERY_OPTIONS);
    }

    @After
    public void tearDown() {
        this.discovery.close();
        AtomicBoolean completed = new AtomicBoolean();
        this.vertx.close(v -> completed.set(true));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
        Assertions.assertThat((Iterable)this.discovery.bindings()).isEmpty();
    }

    @Test
    public void testRX(TestContext tc) {
        HelloServiceImpl svc = new HelloServiceImpl();
        ProxyHelper.registerService(HelloService.class, (Vertx)this.vertx, (Object)svc, (String)"my-service");
        AtomicBoolean httpEndpointPublished = new AtomicBoolean();
        AtomicBoolean serviceProxyPublished = new AtomicBoolean();
        AtomicBoolean jdbcDataSourcePublished = new AtomicBoolean();
        AtomicBoolean messageSource1Published = new AtomicBoolean();
        AtomicBoolean messageSource2Published = new AtomicBoolean();
        AtomicBoolean redisDataSourcePublished = new AtomicBoolean();
        AtomicBoolean mongoDataSourcePublished = new AtomicBoolean();
        this.discovery.publish(HttpEndpoint.createRecord((String)"my-http-service", (String)"localhost", (int)8080, (String)"/"), ar -> httpEndpointPublished.set(ar.succeeded()));
        this.discovery.publish(EventBusService.createRecord((String)"my-service", (String)"my-service", (String)HelloService.class.getName()), ar -> serviceProxyPublished.set(ar.succeeded()));
        this.discovery.publish(JDBCDataSource.createRecord((String)"my-data-source", (JsonObject)new JsonObject().put("url", (Object)"jdbc:hsqldb:file:target/dumb-db;shutdown=true"), (JsonObject)new JsonObject().put("database", (Object)"some-raw-data")), ar -> jdbcDataSourcePublished.set(ar.succeeded()));
        this.discovery.publish(MessageSource.createRecord((String)"my-message-source-1", (String)"source1"), ar -> messageSource1Published.set(ar.succeeded()));
        this.discovery.publish(MessageSource.createRecord((String)"my-message-source-2", (String)"source2", (String)JsonObject.class.getName()), ar -> messageSource2Published.set(ar.succeeded()));
        this.discovery.publish(RedisDataSource.createRecord((String)"my-redis-data-source", (JsonObject)new JsonObject().put("url", (Object)"localhost"), (JsonObject)new JsonObject().put("database", (Object)"some-raw-data")), ar -> redisDataSourcePublished.set(ar.succeeded()));
        this.discovery.publish(MongoDataSource.createRecord((String)"my-mongo-data-source", (JsonObject)new JsonObject().put("connection_string", (Object)"mongodb://localhost:12345"), (JsonObject)new JsonObject().put("database", (Object)"some-raw-data")), ar -> mongoDataSourcePublished.set(ar.succeeded()));
        Awaitility.await().untilAtomic(httpEndpointPublished, Is.is((Object)true));
        Awaitility.await().untilAtomic(serviceProxyPublished, Is.is((Object)true));
        Awaitility.await().untilAtomic(jdbcDataSourcePublished, Is.is((Object)true));
        Awaitility.await().untilAtomic(messageSource1Published, Is.is((Object)true));
        Awaitility.await().untilAtomic(messageSource2Published, Is.is((Object)true));
        Awaitility.await().untilAtomic(redisDataSourcePublished, Is.is((Object)true));
        Awaitility.await().untilAtomic(mongoDataSourcePublished, Is.is((Object)true));
        Async deployment = tc.async();
        Async http_ref = tc.async();
        Async http_sugar = tc.async();
        Async web_ref = tc.async();
        Async web_sugar = tc.async();
        Async svc_ref = tc.async();
        Async svc_sugar = tc.async();
        Async ds_ref = tc.async();
        Async ds_sugar = tc.async();
        Async ms_ref = tc.async();
        Async ms_sugar = tc.async();
        Async redis_ref = tc.async();
        Async redis_sugar = tc.async();
        Async mongo_ref = tc.async();
        Async mongo_sugar = tc.async();
        this.vertx.deployVerticle(MyRXVerticle.class.getName(), deployed -> {
            this.vertx.eventBus().request("http-ref", (Object)"", tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("HttpClient"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
                http_ref.complete();
            }));
            this.vertx.eventBus().request("http-sugar", (Object)"", tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("HttpClient"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
                http_sugar.complete();
            }));
            this.vertx.eventBus().request("web-ref", (Object)"", tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("WebClient"));
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("rx"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
                web_ref.complete();
            }));
            this.vertx.eventBus().request("web-sugar", (Object)"", tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("WebClient"));
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("rx"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
                web_sugar.complete();
            }));
            this.vertx.eventBus().request("service-sugar", (Object)"", tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("HelloService"));
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("rx"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
                svc_sugar.complete();
            }));
            this.vertx.eventBus().request("service-ref", (Object)"", tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("HelloService"));
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("rx"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
                svc_ref.complete();
            }));
            this.vertx.eventBus().request("ds-sugar", (Object)"", tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("JDBCClient"));
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("rx"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
                ds_sugar.complete();
            }));
            this.vertx.eventBus().request("ds-ref", (Object)"", tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("JDBCClient"));
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("rx"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
                ds_ref.complete();
            }));
            this.vertx.eventBus().request("redis-sugar", (Object)"", tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("Redis"));
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("rx"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
                redis_sugar.complete();
            }));
            this.vertx.eventBus().request("redis-ref", (Object)"", tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("Redis"));
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("rx"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
                redis_ref.complete();
            }));
            this.vertx.eventBus().request("mongo-sugar", (Object)"", tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("MongoClient"));
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("rx"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
                mongo_sugar.complete();
            }));
            this.vertx.eventBus().request("mongo-ref", (Object)"", tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("MongoClient"));
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("rx"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
                mongo_ref.complete();
            }));
            this.vertx.eventBus().request("source1-sugar", (Object)"", tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("MessageConsumer"));
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("rx"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
                ms_sugar.complete();
            }));
            this.vertx.eventBus().request("source1-ref", (Object)"", tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("MessageConsumer"));
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("rx"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
                ms_ref.complete();
            }));
            deployment.complete();
        });
    }

    @Test
    public void testWithRXConsumer() {
        HelloServiceImpl svc = new HelloServiceImpl("stuff");
        ProxyHelper.registerService(HelloService.class, (Vertx)this.vertx, (Object)svc, (String)"address");
        Record record = EventBusService.createRecord((String)"Hello", (String)"address", HelloService.class);
        this.discovery.publish(record, r -> {});
        Awaitility.await().until(() -> record.getRegistration() != null);
        AtomicReference result = new AtomicReference();
        this.vertx.eventBus().consumer("result", message -> result.set((JsonObject)message.body()));
        this.vertx.deployVerticle(RXHelloServiceConsumer.class.getName(), ar -> {
            if (ar.failed()) {
                ar.cause().printStackTrace();
            }
        });
        Awaitility.await().until(() -> result.get() != null);
        Assertions.assertThat((String)((JsonObject)result.get()).getString("status")).isEqualTo((Object)"ok");
        Assertions.assertThat((String)((JsonObject)result.get()).getString("message")).isEqualTo((Object)"stuff vert.x");
    }
}

