/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java.test;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.test.SimplePojo;
import io.vertx.lang.rx.test.TestSubscriber;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.test.TestUtils;
import io.vertx.rxjava.core.buffer.Buffer;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Test;
import rx.Observable;

public class BufferTest {
    @Test
    public void testBufferReduce() {
        Observable stream = Observable.from(Arrays.asList(io.vertx.core.buffer.Buffer.buffer((String)"lorem"), io.vertx.core.buffer.Buffer.buffer((String)"ipsum")));
        Observable reduced = stream.reduce(io.vertx.core.buffer.Buffer::appendBuffer);
        TestSubscriber sub = new TestSubscriber();
        TestUtils.subscribe((Observable)reduced, (TestSubscriber)sub);
        sub.assertItem((Object)io.vertx.core.buffer.Buffer.buffer((String)"loremipsum"));
        sub.assertCompleted();
        sub.assertEmpty();
    }

    @Test
    public void testUnmarshallJsonObjectFromBuffer() {
        Observable stream = Observable.from(Arrays.asList(io.vertx.core.buffer.Buffer.buffer((String)"{\"foo\":\"bar\"}")));
        Observable mapped = stream.map(buffer -> new JsonObject(buffer.toString("UTF-8")));
        TestSubscriber sub = new TestSubscriber();
        TestUtils.subscribe((Observable)mapped, (TestSubscriber)sub);
        sub.assertItem((Object)new JsonObject().put("foo", (Object)"bar"));
        sub.assertCompleted();
        sub.assertEmpty();
    }

    @Test
    public void testMapPojoFromBuffer() throws Exception {
        Observable stream = Observable.from(Arrays.asList(io.vertx.core.buffer.Buffer.buffer((String)"{\"foo\":\"bar\"}")));
        Observable mapped = stream.lift(RxHelper.unmarshaller(SimplePojo.class));
        TestSubscriber sub = new TestSubscriber();
        TestUtils.subscribe((Observable)mapped, (TestSubscriber)sub);
        sub.assertItem((Object)new SimplePojo("bar"));
        sub.assertCompleted();
        sub.assertEmpty();
    }

    @Test
    public void testMapObjectNodeFromBuffer() throws Exception {
        Observable stream = Observable.from(Arrays.asList(io.vertx.core.buffer.Buffer.buffer((String)"{\"foo\":\"bar\"}")));
        Observable mapped = stream.lift(RxHelper.unmarshaller(JsonNode.class));
        TestSubscriber sub = new TestSubscriber();
        TestUtils.subscribe((Observable)mapped, (TestSubscriber)sub);
        sub.assertItem((Object)new ObjectMapper().createObjectNode().put("foo", "bar"));
        sub.assertCompleted();
        sub.assertEmpty();
    }

    @Test
    public void testClusterSerializable() throws Exception {
        Buffer buff = Buffer.buffer((String)"hello-world");
        io.vertx.core.buffer.Buffer actual = io.vertx.core.buffer.Buffer.buffer();
        buff.writeToBuffer(actual);
        io.vertx.core.buffer.Buffer expected = io.vertx.core.buffer.Buffer.buffer();
        io.vertx.core.buffer.Buffer.buffer((String)"hello-world").writeToBuffer(expected);
        TestCase.assertEquals((Object)expected, (Object)actual);
        buff = Buffer.buffer((String)"hello-world");
        TestCase.assertEquals((int)expected.length(), (int)buff.readFromBuffer(0, expected));
        TestCase.assertEquals((String)"hello-world", (String)buff.toString());
    }

    @Test
    public void testMapPojoListFromBuffer() throws Exception {
        Observable stream = Observable.just((Object)io.vertx.core.buffer.Buffer.buffer((String)"[{\"foo\":\"bar\"}]"));
        Observable mapped = stream.lift(RxHelper.unmarshaller((TypeReference)new TypeReference<List<SimplePojo>>(){}));
        TestSubscriber sub = new TestSubscriber();
        TestUtils.subscribe((Observable)mapped, (TestSubscriber)sub);
        sub.assertItems((Object[])new List[]{Arrays.asList(new SimplePojo("bar"))});
        sub.assertCompleted();
        sub.assertEmpty();
    }
}

