/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java.test;

import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.rxjava.core.buffer.Buffer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class EqualityTest {
    @Test
    public void testBufferEquality() {
        Buffer buf1 = Buffer.buffer((String)"The quick brown fox jumps over the lazy dog");
        Buffer buf2 = buf1.copy();
        Assert.assertNotSame((Object)buf1, (Object)buf2);
        Assert.assertEquals((Object)buf1, (Object)buf2);
    }

    @Test
    public void testBufferSet() {
        Buffer buf1 = Buffer.buffer((String)"The quick brown fox jumps over the lazy dog");
        Buffer buf2 = buf1.copy();
        Assert.assertEquals((long)1L, (long)Stream.of(buf1, buf2).collect(Collectors.toSet()).size());
    }

    @Test
    public void testSocketAddressEquality() {
        io.vertx.rxjava.core.net.SocketAddress address1 = io.vertx.rxjava.core.net.SocketAddress.newInstance((SocketAddress)new SocketAddressImpl(8888, "guest"));
        io.vertx.rxjava.core.net.SocketAddress address2 = io.vertx.rxjava.core.net.SocketAddress.newInstance((SocketAddress)new SocketAddressImpl(8888, "guest"));
        Assert.assertNotSame((Object)address1, (Object)address2);
        Assert.assertEquals((Object)address1, (Object)address2);
    }

    @Test
    public void testSocketAddressSet() {
        io.vertx.rxjava.core.net.SocketAddress address1 = io.vertx.rxjava.core.net.SocketAddress.newInstance((SocketAddress)new SocketAddressImpl(8888, "guest"));
        io.vertx.rxjava.core.net.SocketAddress address2 = io.vertx.rxjava.core.net.SocketAddress.newInstance((SocketAddress)new SocketAddressImpl(8888, "guest"));
        Assert.assertEquals((long)1L, (long)Stream.of(address1, address2).collect(Collectors.toSet()).size());
    }
}

