/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java.test;

import io.vertx.rxjava.core.AbstractVerticle;
import io.vertx.rxjava.core.Vertx;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;
import rx.Completable;

public class VerticleTest
extends VertxTestBase {
    private static final RuntimeException err = new RuntimeException();
    private static volatile int startedCount;
    private static volatile int stoppedCount;
    private Vertx vertx;

    public void setUp() throws Exception {
        super.setUp();
        this.vertx = new Vertx(((VertxTestBase)this).vertx);
        startedCount = 0;
        stoppedCount = 0;
    }

    @Test
    public void testStart() {
        this.vertx.deployVerticle(StartVerticle.class.getName(), this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testStartWithFailure() {
        this.vertx.deployVerticle(StartVerticleWithFailure.class.getName(), this.onFailure(t -> {
            this.assertEquals(t, err);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testStartWithError() {
        this.vertx.deployVerticle(StartVerticleWithError.class.getName(), this.onFailure(t -> {
            this.assertEquals(t, err);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testStartSynchronously() {
        this.vertx.deployVerticle(StartVerticleSynchronously.class.getName(), this.onSuccess(t -> {
            this.assertEquals(1L, startedCount);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testStop() {
        this.vertx.deployVerticle(StopVerticle.class.getName(), this.onSuccess(id -> this.vertx.undeploy(id, this.onSuccess(v -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testStopWithFailure() {
        this.vertx.deployVerticle(StopVerticleWithFailure.class.getName(), this.onSuccess(id -> this.vertx.undeploy(id, this.onFailure(t -> {
            this.assertEquals(t, err);
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testStopWithError() {
        this.vertx.deployVerticle(StopVerticleWithError.class.getName(), this.onSuccess(id -> this.vertx.undeploy(id, this.onFailure(t -> {
            this.assertEquals(t, err);
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testStopSynchronously() {
        this.vertx.deployVerticle(StopVerticleSynchronously.class.getName(), this.onSuccess(id -> this.vertx.undeploy(id, this.onSuccess(v -> {
            this.assertEquals(1L, stoppedCount);
            this.testComplete();
        }))));
        this.await();
    }

    public static class StopVerticleSynchronously
    extends AbstractVerticle {
        public void stop() {
            stoppedCount++;
        }
    }

    public static class StopVerticleWithError
    extends AbstractVerticle {
        public Completable rxStop() {
            return Completable.error((Throwable)err);
        }
    }

    public static class StopVerticleWithFailure
    extends AbstractVerticle {
        public Completable rxStop() {
            throw err;
        }
    }

    public static class StopVerticle
    extends AbstractVerticle {
        public Completable rxStop() {
            return Completable.complete();
        }
    }

    public static class StartVerticleSynchronously
    extends AbstractVerticle {
        public void start() {
            startedCount++;
        }
    }

    public static class StartVerticleWithError
    extends AbstractVerticle {
        public Completable rxStart() {
            return Completable.error((Throwable)err);
        }
    }

    public static class StartVerticleWithFailure
    extends AbstractVerticle {
        public Completable rxStart() {
            throw err;
        }
    }

    public static class StartVerticle
    extends AbstractVerticle {
        public Completable rxStart() {
            return Completable.complete();
        }
    }
}

