/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.sql;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.rxjava.ext.jdbc.JDBCClient;
import io.vertx.rxjava.ext.sql.SQLClient;
import io.vertx.rxjava.ext.sql.SQLConnection;
import io.vertx.test.core.VertxTestBase;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.junit.Assert;
import rx.Completable;
import rx.Observable;

public abstract class SQLTestBase
extends VertxTestBase {
    protected static final List<String> NAMES = Arrays.asList("John", "Paul", "Peter", "Andrew", "Peter", "Steven");
    protected static final String UNIQUE_NAMES_SQL = "select distinct firstname from folks order by firstname asc";
    protected static final String INSERT_FOLK_SQL = "insert into folks (firstname) values ('%s')";
    private static final JsonObject config = new JsonObject().put("driver_class", (Object)"org.hsqldb.jdbcDriver").put("url", (Object)"jdbc:hsqldb:mem:test?shutdown=true");
    protected SQLClient client;

    public void setUp() throws Exception {
        super.setUp();
        this.client = new JDBCClient(io.vertx.ext.jdbc.JDBCClient.create((Vertx)this.vertx, (JsonObject)config));
        this.client.rxGetConnection().flatMapCompletable(conn -> {
            Completable setup = conn.rxExecute("drop table folks if exists").toCompletable().andThen(conn.rxExecute("create table folks (firstname varchar(255) not null)").toCompletable());
            for (String name : NAMES) {
                setup = setup.andThen(conn.rxExecute(String.format(INSERT_FOLK_SQL, name)).toCompletable());
            }
            return setup.doAfterTerminate(() -> ((SQLConnection)conn).close());
        }).await();
    }

    protected void assertTableContainsInitDataOnly() throws Exception {
        this.client.rxGetConnection().flatMapObservable(conn -> this.uniqueNames((SQLConnection)conn).doAfterTerminate(() -> ((SQLConnection)conn).close())).test().awaitTerminalEvent().assertCompleted().assertValues((Object[])((String[])NAMES.stream().sorted().distinct().toArray(String[]::new)));
    }

    protected Observable<String> uniqueNames(SQLConnection conn) {
        return conn.rxQuery(UNIQUE_NAMES_SQL).flatMapObservable(resultSet -> Observable.from((Iterable)resultSet.getResults())).map(row -> row.getString(0));
    }

    protected Completable rxInsertExtraFolks(SQLConnection conn) {
        return conn.rxExecute(String.format(INSERT_FOLK_SQL, "Georges")).toCompletable().andThen(conn.rxExecute(String.format(INSERT_FOLK_SQL, "Henry")).toCompletable());
    }

    protected String[] namesWithExtraFolks() {
        return (String[])Stream.concat(NAMES.stream(), Stream.of("Georges", "Henry")).sorted().distinct().toArray(String[]::new);
    }

    protected Completable rxAssertEquals(Object expected, Object actual) {
        Completable completable;
        try {
            Assert.assertEquals((Object)expected, (Object)actual);
            completable = Completable.complete();
        }
        catch (AssertionError error) {
            completable = Completable.error((Throwable)((Object)error));
        }
        return completable;
    }

    protected Completable rxAssertAutoCommit(SQLConnection conn) {
        String testName = UUID.randomUUID().toString();
        return conn.rxExecute(String.format(INSERT_FOLK_SQL, testName)).toCompletable().andThen(this.client.rxGetConnection().flatMapCompletable(other -> this.uniqueNames((SQLConnection)other).contains((Object)testName).toSingle().flatMapCompletable(contains -> {
            if (contains.booleanValue()) {
                return Completable.complete();
            }
            return Completable.error((Throwable)((Object)new AssertionError((Object)"Connection should be back in autocommit mode")));
        }).doAfterTerminate(() -> ((SQLConnection)other).close())));
    }

    public void tearDown() throws Exception {
        this.client.rxClose().toCompletable().await();
    }
}

