/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.sql;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.rxjava.ext.jdbc.JDBCClient;
import io.vertx.rxjava.ext.sql.SQLClient;
import io.vertx.rxjava.ext.sql.SQLClientHelper;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.junit.Test;
import rx.observers.AssertableSubscriber;

public class UsingConnectionSafetyTest
extends VertxTestBase {
    private static final int MAX_POOL_SIZE = 5;
    private static final JsonObject config = new JsonObject().put("driver_class", (Object)"org.hsqldb.jdbcDriver").put("url", (Object)"jdbc:hsqldb:mem:test?shutdown=true").put("max_pool_size", (Object)5);
    private SQLClient client;

    public void setUp() throws Exception {
        super.setUp();
        this.client = new JDBCClient(io.vertx.ext.jdbc.JDBCClient.create((Vertx)this.vertx, (JsonObject)config));
    }

    @Test
    public void testUsingConnectionObservable() throws Exception {
        this.doTest(runtimeException -> SQLClientHelper.usingConnectionObservable((SQLClient)this.client, conn -> {
            throw runtimeException;
        }).test());
    }

    @Test
    public void testUsingConnectionSingle() throws Exception {
        this.doTest(runtimeException -> SQLClientHelper.usingConnectionSingle((SQLClient)this.client, conn -> {
            throw runtimeException;
        }).test());
    }

    @Test
    public void testUsingConnectionCompletable() throws Exception {
        this.doTest(runtimeException -> SQLClientHelper.usingConnectionCompletable((SQLClient)this.client, conn -> {
            throw runtimeException;
        }).test());
    }

    private void doTest(Function<RuntimeException, AssertableSubscriber> test) {
        for (int i = 0; i < 6; ++i) {
            RuntimeException expected = new RuntimeException();
            AssertableSubscriber assertableSubscriber = test.apply(expected);
            assertableSubscriber.awaitTerminalEvent(5L, TimeUnit.SECONDS).assertNoValues().assertError((Throwable)expected);
        }
    }

    public void tearDown() throws Exception {
        this.client.rxClose().toCompletable().await();
    }
}

