/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.tests;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.rxjava.core.Vertx;
import io.vertx.rxjava.core.http.HttpClient;
import io.vertx.rxjava.core.http.HttpClientResponse;
import io.vertx.rxjava.core.http.HttpServer;
import io.vertx.rxjava.ext.web.Router;
import io.vertx.rxjava.rxjava.tests.web.TestRouteHandler;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;

public class WebTest
extends VertxTestBase {
    private Vertx vertx;
    private Router router;
    private HttpServer server;
    private HttpClient client;

    public void setUp() throws Exception {
        super.setUp();
        this.vertx = new Vertx(((VertxTestBase)this).vertx);
        this.router = Router.router((Vertx)this.vertx);
        this.server = (HttpServer)this.vertx.createHttpServer().requestHandler((Handler)this.router).rxListen(8080, "localhost").toBlocking().value();
        this.client = this.vertx.createHttpClient();
    }

    @Test
    public void testOrderListenerIsInvoked() {
        this.router.get().handler((Handler)TestRouteHandler.create());
        int statusCode = (Integer)this.client.rxRequest(HttpMethod.GET, 8080, "localhost", "/").flatMap(request -> request.rxSend().map(HttpClientResponse::statusCode)).toBlocking().value();
        this.assertEquals(200L, statusCode);
    }

    public void tearDown() throws Exception {
        if (this.client != null) {
            this.client.rxClose().onErrorReturn(t -> null).toBlocking().value();
        }
        if (this.server != null) {
            this.server.rxClose().onErrorReturn(t -> null).toBlocking().value();
        }
        super.tearDown();
    }
}

