/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.net.SSLOptions;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rxjava.Helper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.MultiMap;
import io.vertx.rxjava.core.http.HttpClientRequest;
import io.vertx.rxjava.core.http.HttpClientResponse;
import io.vertx.rxjava.core.http.HttpConnection;
import io.vertx.rxjava.core.http.WebSocket;
import io.vertx.rxjava.core.metrics.Measured;
import java.util.List;
import java.util.function.Function;
import rx.Single;

@RxGen(value=io.vertx.core.http.HttpClient.class)
public class HttpClient
implements RxDelegate,
Measured {
    public static final TypeArg<HttpClient> __TYPE_ARG = new TypeArg(obj -> new HttpClient((io.vertx.core.http.HttpClient)obj), HttpClient::getDelegate);
    private final io.vertx.core.http.HttpClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClient that = (HttpClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpClient(io.vertx.core.http.HttpClient delegate) {
        this.delegate = delegate;
    }

    public HttpClient(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpClient)delegate;
    }

    public io.vertx.core.http.HttpClient getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public void request(RequestOptions options, Handler<AsyncResult<HttpClientRequest>> handler) {
        this.delegate.request(options, Helper.convertHandler(handler, ar -> ar.map(event -> HttpClientRequest.newInstance(event))));
    }

    public void request(RequestOptions options) {
        this.request(options, (Handler<AsyncResult<HttpClientRequest>>)((Handler)ar -> {}));
    }

    public Single<HttpClientRequest> rxRequest(RequestOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.request(options, (Handler<AsyncResult<HttpClientRequest>>)fut)));
    }

    public void request(HttpMethod method, int port, String host, String requestURI, Handler<AsyncResult<HttpClientRequest>> handler) {
        this.delegate.request(method, port, host, requestURI, Helper.convertHandler(handler, ar -> ar.map(event -> HttpClientRequest.newInstance(event))));
    }

    public void request(HttpMethod method, int port, String host, String requestURI) {
        this.request(method, port, host, requestURI, (Handler<AsyncResult<HttpClientRequest>>)((Handler)ar -> {}));
    }

    public Single<HttpClientRequest> rxRequest(HttpMethod method, int port, String host, String requestURI) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.request(method, port, host, requestURI, (Handler<AsyncResult<HttpClientRequest>>)fut)));
    }

    public void request(HttpMethod method, String host, String requestURI, Handler<AsyncResult<HttpClientRequest>> handler) {
        this.delegate.request(method, host, requestURI, Helper.convertHandler(handler, ar -> ar.map(event -> HttpClientRequest.newInstance(event))));
    }

    public void request(HttpMethod method, String host, String requestURI) {
        this.request(method, host, requestURI, (Handler<AsyncResult<HttpClientRequest>>)((Handler)ar -> {}));
    }

    public Single<HttpClientRequest> rxRequest(HttpMethod method, String host, String requestURI) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.request(method, host, requestURI, (Handler<AsyncResult<HttpClientRequest>>)fut)));
    }

    public void request(HttpMethod method, String requestURI, Handler<AsyncResult<HttpClientRequest>> handler) {
        this.delegate.request(method, requestURI, Helper.convertHandler(handler, ar -> ar.map(event -> HttpClientRequest.newInstance(event))));
    }

    public void request(HttpMethod method, String requestURI) {
        this.request(method, requestURI, (Handler<AsyncResult<HttpClientRequest>>)((Handler)ar -> {}));
    }

    public Single<HttpClientRequest> rxRequest(HttpMethod method, String requestURI) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.request(method, requestURI, (Handler<AsyncResult<HttpClientRequest>>)fut)));
    }

    @Deprecated
    public void webSocket(int port, String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocket(port, host, requestURI, Helper.convertHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event))));
    }

    @Deprecated
    public void webSocket(int port, String host, String requestURI) {
        this.webSocket(port, host, requestURI, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    @Deprecated
    public Single<WebSocket> rxWebSocket(int port, String host, String requestURI) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.webSocket(port, host, requestURI, (Handler<AsyncResult<WebSocket>>)fut)));
    }

    @Deprecated
    public void webSocket(String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocket(host, requestURI, Helper.convertHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event))));
    }

    @Deprecated
    public void webSocket(String host, String requestURI) {
        this.webSocket(host, requestURI, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    @Deprecated
    public Single<WebSocket> rxWebSocket(String host, String requestURI) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.webSocket(host, requestURI, (Handler<AsyncResult<WebSocket>>)fut)));
    }

    @Deprecated
    public void webSocket(String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocket(requestURI, Helper.convertHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event))));
    }

    @Deprecated
    public void webSocket(String requestURI) {
        this.webSocket(requestURI, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    @Deprecated
    public Single<WebSocket> rxWebSocket(String requestURI) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.webSocket(requestURI, (Handler<AsyncResult<WebSocket>>)fut)));
    }

    @Deprecated
    public void webSocket(WebSocketConnectOptions options, Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocket(options, Helper.convertHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event))));
    }

    @Deprecated
    public void webSocket(WebSocketConnectOptions options) {
        this.webSocket(options, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    @Deprecated
    public Single<WebSocket> rxWebSocket(WebSocketConnectOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.webSocket(options, (Handler<AsyncResult<WebSocket>>)fut)));
    }

    @Deprecated
    public void webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols, Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocketAbs(url, headers.getDelegate(), version, subProtocols, Helper.convertHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event))));
    }

    @Deprecated
    public void webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols) {
        this.webSocketAbs(url, headers, version, subProtocols, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    @Deprecated
    public Single<WebSocket> rxWebSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.webSocketAbs(url, headers, version, subProtocols, (Handler<AsyncResult<WebSocket>>)fut)));
    }

    public void updateSSLOptions(SSLOptions options, Handler<AsyncResult<Boolean>> handler) {
        this.delegate.updateSSLOptions(options, handler);
    }

    public void updateSSLOptions(SSLOptions options) {
        this.updateSSLOptions(options, (Handler<AsyncResult<Boolean>>)((Handler)ar -> {}));
    }

    public Single<Boolean> rxUpdateSSLOptions(SSLOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.updateSSLOptions(options, (Handler<AsyncResult<Boolean>>)fut)));
    }

    public void updateSSLOptions(SSLOptions options, boolean force, Handler<AsyncResult<Boolean>> handler) {
        this.delegate.updateSSLOptions(options, force, handler);
    }

    public void updateSSLOptions(SSLOptions options, boolean force) {
        this.updateSSLOptions(options, force, (Handler<AsyncResult<Boolean>>)((Handler)ar -> {}));
    }

    public Single<Boolean> rxUpdateSSLOptions(SSLOptions options, boolean force) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.updateSSLOptions(options, force, (Handler<AsyncResult<Boolean>>)fut)));
    }

    @Deprecated
    public HttpClient connectionHandler(Handler<HttpConnection> handler) {
        this.delegate.connectionHandler(Helper.convertHandler(handler, event -> HttpConnection.newInstance(event)));
        return this;
    }

    @Deprecated
    public HttpClient redirectHandler(final Function<HttpClientResponse, Future<RequestOptions>> handler) {
        this.delegate.redirectHandler((Function)new Function<io.vertx.core.http.HttpClientResponse, Future<RequestOptions>>(){

            @Override
            public Future<RequestOptions> apply(io.vertx.core.http.HttpClientResponse arg) {
                Future ret = (Future)handler.apply(HttpClientResponse.newInstance(arg));
                return ret.map(val -> val);
            }
        });
        return this;
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxClose() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public static HttpClient newInstance(io.vertx.core.http.HttpClient arg) {
        return arg != null ? new HttpClient(arg) : null;
    }
}

