/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.net;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.net.SSLOptions;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rxjava.Helper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.metrics.Measured;
import io.vertx.rxjava.core.net.NetSocket;
import io.vertx.rxjava.core.net.SocketAddress;
import rx.Single;

@RxGen(value=io.vertx.core.net.NetClient.class)
public class NetClient
implements RxDelegate,
Measured {
    public static final TypeArg<NetClient> __TYPE_ARG = new TypeArg(obj -> new NetClient((io.vertx.core.net.NetClient)obj), NetClient::getDelegate);
    private final io.vertx.core.net.NetClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetClient that = (NetClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public NetClient(io.vertx.core.net.NetClient delegate) {
        this.delegate = delegate;
    }

    public NetClient(Object delegate) {
        this.delegate = (io.vertx.core.net.NetClient)delegate;
    }

    public io.vertx.core.net.NetClient getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public NetClient connect(int port, String host, Handler<AsyncResult<NetSocket>> connectHandler) {
        this.delegate.connect(port, host, Helper.convertHandler(connectHandler, ar -> ar.map(event -> NetSocket.newInstance(event))));
        return this;
    }

    public NetClient connect(int port, String host) {
        return this.connect(port, host, (Handler<AsyncResult<NetSocket>>)((Handler)ar -> {}));
    }

    public Single<NetSocket> rxConnect(int port, String host) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.connect(port, host, (Handler<AsyncResult<NetSocket>>)fut)));
    }

    public NetClient connect(int port, String host, String serverName, Handler<AsyncResult<NetSocket>> connectHandler) {
        this.delegate.connect(port, host, serverName, Helper.convertHandler(connectHandler, ar -> ar.map(event -> NetSocket.newInstance(event))));
        return this;
    }

    public NetClient connect(int port, String host, String serverName) {
        return this.connect(port, host, serverName, (Handler<AsyncResult<NetSocket>>)((Handler)ar -> {}));
    }

    public Single<NetSocket> rxConnect(int port, String host, String serverName) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.connect(port, host, serverName, (Handler<AsyncResult<NetSocket>>)fut)));
    }

    public NetClient connect(SocketAddress remoteAddress, Handler<AsyncResult<NetSocket>> connectHandler) {
        this.delegate.connect(remoteAddress.getDelegate(), Helper.convertHandler(connectHandler, ar -> ar.map(event -> NetSocket.newInstance(event))));
        return this;
    }

    public NetClient connect(SocketAddress remoteAddress) {
        return this.connect(remoteAddress, (Handler<AsyncResult<NetSocket>>)((Handler)ar -> {}));
    }

    public Single<NetSocket> rxConnect(SocketAddress remoteAddress) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.connect(remoteAddress, (Handler<AsyncResult<NetSocket>>)fut)));
    }

    public NetClient connect(SocketAddress remoteAddress, String serverName, Handler<AsyncResult<NetSocket>> connectHandler) {
        this.delegate.connect(remoteAddress.getDelegate(), serverName, Helper.convertHandler(connectHandler, ar -> ar.map(event -> NetSocket.newInstance(event))));
        return this;
    }

    public NetClient connect(SocketAddress remoteAddress, String serverName) {
        return this.connect(remoteAddress, serverName, (Handler<AsyncResult<NetSocket>>)((Handler)ar -> {}));
    }

    public Single<NetSocket> rxConnect(SocketAddress remoteAddress, String serverName) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.connect(remoteAddress, serverName, (Handler<AsyncResult<NetSocket>>)fut)));
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxClose() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public void updateSSLOptions(SSLOptions options, Handler<AsyncResult<Boolean>> handler) {
        this.delegate.updateSSLOptions(options, handler);
    }

    public void updateSSLOptions(SSLOptions options) {
        this.updateSSLOptions(options, (Handler<AsyncResult<Boolean>>)((Handler)ar -> {}));
    }

    public Single<Boolean> rxUpdateSSLOptions(SSLOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.updateSSLOptions(options, (Handler<AsyncResult<Boolean>>)fut)));
    }

    public void updateSSLOptions(SSLOptions options, boolean force, Handler<AsyncResult<Boolean>> handler) {
        this.delegate.updateSSLOptions(options, force, handler);
    }

    public void updateSSLOptions(SSLOptions options, boolean force) {
        this.updateSSLOptions(options, force, (Handler<AsyncResult<Boolean>>)((Handler)ar -> {}));
    }

    public Single<Boolean> rxUpdateSSLOptions(SSLOptions options, boolean force) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.updateSSLOptions(options, force, (Handler<AsyncResult<Boolean>>)fut)));
    }

    public static NetClient newInstance(io.vertx.core.net.NetClient arg) {
        return arg != null ? new NetClient(arg) : null;
    }
}

