/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.redis.client;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rxjava.Helper;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.streams.Pipe;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.core.streams.WriteStream;
import io.vertx.rxjava.redis.client.Request;
import io.vertx.rxjava.redis.client.Response;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.redis.client.RedisConnection.class)
public class RedisConnection
implements RxDelegate,
ReadStream<Response> {
    public static final TypeArg<RedisConnection> __TYPE_ARG = new TypeArg(obj -> new RedisConnection((io.vertx.redis.client.RedisConnection)obj), RedisConnection::getDelegate);
    private final io.vertx.redis.client.RedisConnection delegate;
    private Observable<Response> observable;
    private static final TypeArg<Response> TYPE_ARG_0 = new TypeArg(o1 -> Response.newInstance((io.vertx.redis.client.Response)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisConnection that = (RedisConnection)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public RedisConnection(io.vertx.redis.client.RedisConnection delegate) {
        this.delegate = delegate;
    }

    public RedisConnection(Object delegate) {
        this.delegate = (io.vertx.redis.client.RedisConnection)delegate;
    }

    public io.vertx.redis.client.RedisConnection getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<Response> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.redis.client.Response, Response> conv = Response::newInstance;
            this.observable = RxHelper.toObservable((io.vertx.core.streams.ReadStream)this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public Pipe<Response> pipe() {
        Pipe<Response> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    public void pipeTo(WriteStream<Response> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Override
    public void pipeTo(WriteStream<Response> dst) {
        this.pipeTo(dst, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxPipeTo(WriteStream<Response> dst) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public RedisConnection exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public RedisConnection handler(Handler<Response> handler) {
        this.delegate.handler(Helper.convertHandler(handler, event -> Response.newInstance(event)));
        return this;
    }

    public RedisConnection pause() {
        this.delegate.pause();
        return this;
    }

    public RedisConnection resume() {
        this.delegate.resume();
        return this;
    }

    public RedisConnection fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public RedisConnection endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public RedisConnection send(Request command, Handler<AsyncResult<Response>> onSend) {
        this.delegate.send(command.getDelegate(), Helper.convertHandler(onSend, ar -> ar.map(event -> Response.newInstance(event))));
        return this;
    }

    public RedisConnection send(Request command) {
        return this.send(command, (Handler<AsyncResult<Response>>)((Handler)ar -> {}));
    }

    public Single<Response> rxSend(Request command) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.send(command, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisConnection batch(List<Request> commands, Handler<AsyncResult<List<Response>>> onSend) {
        this.delegate.batch(commands.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), Helper.convertHandler(onSend, ar -> ar.map(event -> event.stream().map(elt -> Response.newInstance(elt)).collect(Collectors.toList()))));
        return this;
    }

    public RedisConnection batch(List<Request> commands) {
        return this.batch(commands, (Handler<AsyncResult<List<Response>>>)((Handler)ar -> {}));
    }

    public Single<List<Response>> rxBatch(List<Request> commands) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.batch(commands, (Handler<AsyncResult<List<Response>>>)fut)));
    }

    public RedisConnection close(Handler<AsyncResult<Void>> onClose) {
        this.delegate.close(onClose);
        return this;
    }

    public RedisConnection close() {
        return this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxClose() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public boolean pendingQueueFull() {
        boolean ret = this.delegate.pendingQueueFull();
        return ret;
    }

    public static RedisConnection newInstance(io.vertx.redis.client.RedisConnection arg) {
        return arg != null ? new RedisConnection(arg) : null;
    }
}

