/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.streams.ReadStream;
import io.vertx.lang.reactivex.Helper;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.core.MultiMap;
import io.vertx.reactivex.core.http.HttpClientRequest;
import io.vertx.reactivex.core.http.HttpFrame;
import io.vertx.reactivex.core.http.HttpResponseHead;
import io.vertx.reactivex.core.net.NetSocket;
import io.vertx.reactivex.core.streams.Pipe;
import io.vertx.reactivex.core.streams.WriteStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.List;
import java.util.function.Function;

@RxGen(value=io.vertx.core.http.HttpClientResponse.class)
public class HttpClientResponse
implements RxDelegate,
io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer>,
HttpResponseHead {
    public static final TypeArg<HttpClientResponse> __TYPE_ARG = new TypeArg(obj -> new HttpClientResponse((io.vertx.core.http.HttpClientResponse)obj), HttpClientResponse::getDelegate);
    private final io.vertx.core.http.HttpClientResponse delegate;
    private Observable<io.vertx.reactivex.core.buffer.Buffer> observable;
    private Flowable<io.vertx.reactivex.core.buffer.Buffer> flowable;
    private static final TypeArg<io.vertx.reactivex.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg(o1 -> io.vertx.reactivex.core.buffer.Buffer.newInstance((Buffer)o1), o1 -> o1.getDelegate());
    private MultiMap cached_0;
    private List<String> cached_1;
    private NetSocket cached_2;
    private MultiMap cached_3;
    private HttpClientRequest cached_4;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClientResponse that = (HttpClientResponse)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpClientResponse(io.vertx.core.http.HttpClientResponse delegate) {
        this.delegate = delegate;
    }

    public HttpClientResponse(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpClientResponse)delegate;
    }

    public io.vertx.core.http.HttpClientResponse getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<io.vertx.reactivex.core.buffer.Buffer> toObservable() {
        if (this.observable == null) {
            Function<Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
            this.observable = ObservableHelper.toObservable((ReadStream)this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<io.vertx.reactivex.core.buffer.Buffer> toFlowable() {
        if (this.flowable == null) {
            Function<Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
            this.flowable = FlowableHelper.toFlowable((ReadStream)this.delegate, conv);
        }
        return this.flowable;
    }

    @Override
    public HttpVersion version() {
        HttpVersion ret = this.delegate.version();
        return ret;
    }

    @Override
    public int statusCode() {
        int ret = this.delegate.statusCode();
        return ret;
    }

    @Override
    public String statusMessage() {
        String ret = this.delegate.statusMessage();
        return ret;
    }

    @Override
    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    @Override
    public String getHeader(String headerName) {
        String ret = this.delegate.getHeader(headerName);
        return ret;
    }

    @Override
    public List<String> cookies() {
        List ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = this.delegate.cookies();
        return ret;
    }

    @Override
    public Pipe<io.vertx.reactivex.core.buffer.Buffer> pipe() {
        Pipe<io.vertx.reactivex.core.buffer.Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    public void pipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Override
    public void pipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) {
        this.pipeTo(dst, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxPipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) {
        return AsyncResultCompletable.toCompletable($handler -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)$handler));
    }

    public HttpClientResponse fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public HttpClientResponse resume() {
        this.delegate.resume();
        return this;
    }

    @Override
    public HttpClientResponse exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpClientResponse handler(Handler<io.vertx.reactivex.core.buffer.Buffer> handler) {
        this.delegate.handler(Helper.convertHandler(handler, event -> io.vertx.reactivex.core.buffer.Buffer.newInstance(event)));
        return this;
    }

    public HttpClientResponse pause() {
        this.delegate.pause();
        return this;
    }

    public HttpClientResponse endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public NetSocket netSocket() {
        NetSocket ret;
        if (this.cached_2 != null) {
            return this.cached_2;
        }
        this.cached_2 = ret = NetSocket.newInstance(this.delegate.netSocket());
        return ret;
    }

    public String getTrailer(String trailerName) {
        String ret = this.delegate.getTrailer(trailerName);
        return ret;
    }

    public MultiMap trailers() {
        MultiMap ret;
        if (this.cached_3 != null) {
            return this.cached_3;
        }
        this.cached_3 = ret = MultiMap.newInstance(this.delegate.trailers());
        return ret;
    }

    public HttpClientResponse bodyHandler(Handler<io.vertx.reactivex.core.buffer.Buffer> bodyHandler) {
        this.delegate.bodyHandler(Helper.convertHandler(bodyHandler, event -> io.vertx.reactivex.core.buffer.Buffer.newInstance(event)));
        return this;
    }

    public HttpClientResponse body(Handler<AsyncResult<io.vertx.reactivex.core.buffer.Buffer>> handler) {
        this.delegate.body(Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.reactivex.core.buffer.Buffer.newInstance(event))));
        return this;
    }

    public HttpClientResponse body() {
        return this.body((Handler<AsyncResult<io.vertx.reactivex.core.buffer.Buffer>>)((Handler)ar -> {}));
    }

    public Single<io.vertx.reactivex.core.buffer.Buffer> rxBody() {
        return AsyncResultSingle.toSingle($handler -> this.body((Handler<AsyncResult<io.vertx.reactivex.core.buffer.Buffer>>)$handler));
    }

    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    public void end() {
        this.end((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable($handler -> this.end((Handler<AsyncResult<Void>>)$handler));
    }

    public HttpClientResponse customFrameHandler(Handler<HttpFrame> handler) {
        this.delegate.customFrameHandler(Helper.convertHandler(handler, event -> HttpFrame.newInstance(event)));
        return this;
    }

    public HttpClientRequest request() {
        HttpClientRequest ret;
        if (this.cached_4 != null) {
            return this.cached_4;
        }
        this.cached_4 = ret = HttpClientRequest.newInstance(this.delegate.request());
        return ret;
    }

    public HttpClientResponse streamPriorityHandler(Handler<StreamPriority> handler) {
        this.delegate.streamPriorityHandler(handler);
        return this;
    }

    public String getHeader(CharSequence headerName) {
        String ret = this.delegate.getHeader(headerName);
        return ret;
    }

    public static HttpClientResponse newInstance(io.vertx.core.http.HttpClientResponse arg) {
        return arg != null ? new HttpClientResponse(arg) : null;
    }
}

