/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.sql;

import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.UpdateResult;
import io.vertx.lang.reactivex.Helper;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.ext.sql.SQLConnection;
import io.vertx.reactivex.ext.sql.SQLOperations;
import io.vertx.reactivex.ext.sql.SQLRowStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;

@RxGen(value=io.vertx.ext.sql.SQLClient.class)
public class SQLClient
implements RxDelegate,
SQLOperations {
    public static final TypeArg<SQLClient> __TYPE_ARG = new TypeArg(obj -> new SQLClient((io.vertx.ext.sql.SQLClient)obj), SQLClient::getDelegate);
    private final io.vertx.ext.sql.SQLClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLClient that = (SQLClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public SQLClient(io.vertx.ext.sql.SQLClient delegate) {
        this.delegate = delegate;
    }

    public SQLClient(Object delegate) {
        this.delegate = (io.vertx.ext.sql.SQLClient)delegate;
    }

    public io.vertx.ext.sql.SQLClient getDelegate() {
        return this.delegate;
    }

    @Override
    public SQLOperations querySingle(String sql, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.querySingle(sql, handler);
        return this;
    }

    @Override
    public SQLOperations querySingle(String sql) {
        return this.querySingle(sql, (Handler<AsyncResult<JsonArray>>)((Handler)ar -> {}));
    }

    @Override
    public Maybe<JsonArray> rxQuerySingle(String sql) {
        return AsyncResultMaybe.toMaybe($handler -> this.querySingle(sql, (Handler<AsyncResult<JsonArray>>)$handler));
    }

    @Override
    public SQLOperations querySingleWithParams(String sql, JsonArray arguments, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.querySingleWithParams(sql, arguments, handler);
        return this;
    }

    @Override
    public SQLOperations querySingleWithParams(String sql, JsonArray arguments) {
        return this.querySingleWithParams(sql, arguments, (Handler<AsyncResult<JsonArray>>)((Handler)ar -> {}));
    }

    @Override
    public Maybe<JsonArray> rxQuerySingleWithParams(String sql, JsonArray arguments) {
        return AsyncResultMaybe.toMaybe($handler -> this.querySingleWithParams(sql, arguments, (Handler<AsyncResult<JsonArray>>)$handler));
    }

    public SQLClient getConnection(Handler<AsyncResult<SQLConnection>> handler) {
        this.delegate.getConnection(Helper.convertHandler(handler, ar -> ar.map(event -> SQLConnection.newInstance(event))));
        return this;
    }

    public SQLClient getConnection() {
        return this.getConnection((Handler<AsyncResult<SQLConnection>>)((Handler)ar -> {}));
    }

    public Single<SQLConnection> rxGetConnection() {
        return AsyncResultSingle.toSingle($handler -> this.getConnection((Handler<AsyncResult<SQLConnection>>)$handler));
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close((Handler<AsyncResult<Void>>)$handler));
    }

    public void close() {
        this.delegate.close();
    }

    @Override
    public SQLClient query(String sql, Handler<AsyncResult<ResultSet>> handler) {
        this.delegate.query(sql, handler);
        return this;
    }

    @Override
    public SQLClient query(String sql) {
        return this.query(sql, ar -> {});
    }

    @Override
    public Single<ResultSet> rxQuery(String sql) {
        return AsyncResultSingle.toSingle($handler -> this.query(sql, (Handler)$handler));
    }

    @Override
    public SQLClient queryStream(String sql, Handler<AsyncResult<SQLRowStream>> handler) {
        this.delegate.queryStream(sql, Helper.convertHandler(handler, ar -> ar.map(event -> SQLRowStream.newInstance(event))));
        return this;
    }

    @Override
    public SQLClient queryStream(String sql) {
        return this.queryStream(sql, ar -> {});
    }

    @Override
    public Single<SQLRowStream> rxQueryStream(String sql) {
        return AsyncResultSingle.toSingle($handler -> this.queryStream(sql, (Handler)$handler));
    }

    @Override
    public SQLClient queryStreamWithParams(String sql, JsonArray params, Handler<AsyncResult<SQLRowStream>> handler) {
        this.delegate.queryStreamWithParams(sql, params, Helper.convertHandler(handler, ar -> ar.map(event -> SQLRowStream.newInstance(event))));
        return this;
    }

    @Override
    public SQLClient queryStreamWithParams(String sql, JsonArray params) {
        return this.queryStreamWithParams(sql, params, ar -> {});
    }

    @Override
    public Single<SQLRowStream> rxQueryStreamWithParams(String sql, JsonArray params) {
        return AsyncResultSingle.toSingle($handler -> this.queryStreamWithParams(sql, params, (Handler)$handler));
    }

    @Override
    public SQLClient queryWithParams(String sql, JsonArray arguments, Handler<AsyncResult<ResultSet>> handler) {
        this.delegate.queryWithParams(sql, arguments, handler);
        return this;
    }

    @Override
    public SQLClient queryWithParams(String sql, JsonArray arguments) {
        return this.queryWithParams(sql, arguments, ar -> {});
    }

    @Override
    public Single<ResultSet> rxQueryWithParams(String sql, JsonArray arguments) {
        return AsyncResultSingle.toSingle($handler -> this.queryWithParams(sql, arguments, (Handler)$handler));
    }

    @Override
    public SQLClient update(String sql, Handler<AsyncResult<UpdateResult>> handler) {
        this.delegate.update(sql, handler);
        return this;
    }

    @Override
    public SQLClient update(String sql) {
        return this.update(sql, ar -> {});
    }

    @Override
    public Single<UpdateResult> rxUpdate(String sql) {
        return AsyncResultSingle.toSingle($handler -> this.update(sql, (Handler)$handler));
    }

    @Override
    public SQLClient updateWithParams(String sql, JsonArray params, Handler<AsyncResult<UpdateResult>> handler) {
        this.delegate.updateWithParams(sql, params, handler);
        return this;
    }

    @Override
    public SQLClient updateWithParams(String sql, JsonArray params) {
        return this.updateWithParams(sql, params, ar -> {});
    }

    @Override
    public Single<UpdateResult> rxUpdateWithParams(String sql, JsonArray params) {
        return AsyncResultSingle.toSingle($handler -> this.updateWithParams(sql, params, (Handler)$handler));
    }

    @Override
    public SQLClient call(String sql, Handler<AsyncResult<ResultSet>> handler) {
        this.delegate.call(sql, handler);
        return this;
    }

    @Override
    public SQLClient call(String sql) {
        return this.call(sql, ar -> {});
    }

    @Override
    public Single<ResultSet> rxCall(String sql) {
        return AsyncResultSingle.toSingle($handler -> this.call(sql, (Handler)$handler));
    }

    @Override
    public SQLClient callWithParams(String sql, JsonArray params, JsonArray outputs, Handler<AsyncResult<ResultSet>> handler) {
        this.delegate.callWithParams(sql, params, outputs, handler);
        return this;
    }

    @Override
    public SQLClient callWithParams(String sql, JsonArray params, JsonArray outputs) {
        return this.callWithParams(sql, params, outputs, ar -> {});
    }

    @Override
    public Single<ResultSet> rxCallWithParams(String sql, JsonArray params, JsonArray outputs) {
        return AsyncResultSingle.toSingle($handler -> this.callWithParams(sql, params, outputs, (Handler)$handler));
    }

    public static SQLClient newInstance(io.vertx.ext.sql.SQLClient arg) {
        return arg != null ? new SQLClient(arg) : null;
    }
}

