/*
 * Decompiled with CFR 0.152.
 */
package io.zipkin.server;

import io.zipkin.BinaryAnnotation;
import io.zipkin.DependencyLink;
import io.zipkin.QueryRequest;
import io.zipkin.Span;
import io.zipkin.SpanStore;
import io.zipkin.internal.ApplyTimestampAndDuration;
import io.zipkin.internal.CorrectForClockSkew;
import io.zipkin.internal.MergeById;
import io.zipkin.internal.Nullable;
import io.zipkin.internal.Util;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class InMemorySpanStore
implements SpanStore {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Multimap<Long, Span> traceIdToSpans = new Multimap(LinkedList::new);
    private final Multimap<String, Long> serviceToTraceIds = new Multimap(LinkedHashSet::new);
    private final Multimap<String, String> serviceToSpanNames = new Multimap(LinkedHashSet::new);

    public synchronized void accept(List<Span> spans) {
        for (Span span : spans) {
            span = ApplyTimestampAndDuration.apply((Span)span);
            long traceId = span.traceId;
            String spanName = span.name;
            this.traceIdToSpans.put(span.traceId, span);
            Stream.concat(span.annotations.stream().map(a -> a.endpoint), span.binaryAnnotations.stream().map(a -> a.endpoint)).filter(e -> e != null).map(e -> e.serviceName).distinct().forEach(serviceName -> {
                this.serviceToTraceIds.put((String)serviceName, traceId);
                this.serviceToSpanNames.put((String)serviceName, spanName);
            });
        }
    }

    synchronized void clear() {
        this.traceIdToSpans.clear();
        this.serviceToTraceIds.clear();
    }

    public synchronized List<List<Span>> getTraces(QueryRequest request) {
        Collection<Long> traceIds = this.serviceToTraceIds.get(request.serviceName);
        if (traceIds == null || traceIds.isEmpty()) {
            return Collections.emptyList();
        }
        return InMemorySpanStore.toSortedTraces(traceIds.stream().map(this.traceIdToSpans::get)).stream().filter(InMemorySpanStore.spansPredicate(request)).limit(request.limit).collect(Collectors.toList());
    }

    public synchronized List<List<Span>> getTracesByIds(List<Long> traceIds) {
        if (traceIds.isEmpty()) {
            return Collections.emptyList();
        }
        return InMemorySpanStore.toSortedTraces(traceIds.stream().map(this.traceIdToSpans::get));
    }

    public synchronized List<String> getServiceNames() {
        return Util.sortedList(this.serviceToTraceIds.keySet());
    }

    public synchronized List<String> getSpanNames(String service) {
        if (service == null) {
            return Collections.emptyList();
        }
        service = service.toLowerCase();
        return Util.sortedList(this.serviceToSpanNames.get(service));
    }

    public List<DependencyLink> getDependencies(long endTs, @Nullable Long lookback) {
        return Collections.emptyList();
    }

    public void close() {
    }

    static Predicate<List<Span>> spansPredicate(QueryRequest request) {
        return spans -> {
            Long timestamp = ((Span)spans.get((int)0)).timestamp;
            if (timestamp == null || timestamp < (queryRequest.endTs - queryRequest.lookback) * 1000L || timestamp > queryRequest.endTs * 1000L) {
                return false;
            }
            LinkedHashSet serviceNames = new LinkedHashSet();
            Predicate<Long> durationPredicate = null;
            if (queryRequest.minDuration != null && queryRequest.maxDuration != null) {
                durationPredicate = d -> d >= queryRequest.minDuration && d <= queryRequest.maxDuration;
            } else if (queryRequest.minDuration != null) {
                durationPredicate = d -> d >= queryRequest.minDuration;
            }
            String spanName = queryRequest.spanName;
            LinkedHashSet annotations = new LinkedHashSet(queryRequest.annotations);
            LinkedHashMap binaryAnnotations = new LinkedHashMap(queryRequest.binaryAnnotations);
            LinkedHashSet currentServiceNames = new LinkedHashSet();
            for (Span span : spans) {
                currentServiceNames.clear();
                span.annotations.forEach(a -> {
                    annotations.remove(a.value);
                    if (a.endpoint != null) {
                        serviceNames.add(a.endpoint.serviceName);
                        currentServiceNames.add(a.endpoint.serviceName);
                    }
                });
                span.binaryAnnotations.forEach(b -> {
                    if (b.type == BinaryAnnotation.Type.STRING && binaryAnnotations.containsKey(b.key)) {
                        binaryAnnotations.remove(b.key, new String(b.value, UTF_8));
                    }
                    if (b.endpoint != null) {
                        serviceNames.add(b.endpoint.serviceName);
                        currentServiceNames.add(b.endpoint.serviceName);
                    }
                });
                if (currentServiceNames.contains(queryRequest.serviceName) && durationPredicate != null && durationPredicate.test(span.duration)) {
                    durationPredicate = null;
                }
                if (!span.name.equals(spanName)) continue;
                spanName = null;
            }
            return serviceNames.contains(queryRequest.serviceName) && spanName == null && annotations.isEmpty() && binaryAnnotations.isEmpty() && durationPredicate == null;
        };
    }

    static List<List<Span>> toSortedTraces(Stream<Collection<Span>> unfiltered) {
        return unfiltered.filter(spans -> spans != null && !spans.isEmpty()).map(MergeById::apply).map(CorrectForClockSkew::apply).sorted((left, right) -> ((Span)right.get(0)).compareTo((Span)left.get(0))).collect(Collectors.toList());
    }

    static final class Multimap<K, V> {
        private final Map<K, Collection<V>> delegate = new LinkedHashMap<K, Collection<V>>();
        private final Supplier<Collection<V>> collectionFunction;

        public Multimap(Supplier<Collection<V>> collectionFunction) {
            this.collectionFunction = collectionFunction;
        }

        public Set<K> keySet() {
            return this.delegate.keySet();
        }

        void put(K key, V value) {
            this.delegate.computeIfAbsent(key, k -> this.collectionFunction.get()).add(value);
        }

        void clear() {
            this.delegate.clear();
        }

        Collection<V> get(K key) {
            return this.delegate.get(key);
        }
    }
}

