/*
 * Decompiled with CFR 0.152.
 */
package io.zipkin.server;

import io.zipkin.Codec;
import io.zipkin.QueryRequest;
import io.zipkin.SpanStore;
import io.zipkin.internal.Util;
import io.zipkin.server.ZipkinSpanWriter;
import java.util.Collections;
import java.util.List;
import okio.Buffer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1"})
public class ZipkinQueryApiV1 {
    private static final String APPLICATION_THRIFT = "application/x-thrift";
    private static final String DEFAULT_LOOKBACK = "86400000";
    private final SpanStore spanStore;
    private final ZipkinSpanWriter spanWriter;
    private final Codec jsonCodec;
    private final Codec thriftCodec;

    @Autowired
    public ZipkinQueryApiV1(SpanStore spanStore, ZipkinSpanWriter spanWriter, Codec.Factory codecFactory) {
        this.spanStore = spanStore;
        this.spanWriter = spanWriter;
        this.jsonCodec = (Codec)Util.checkNotNull((Object)codecFactory.get("application/json"), (String)"application/json");
        this.thriftCodec = (Codec)Util.checkNotNull((Object)codecFactory.get(APPLICATION_THRIFT), (String)APPLICATION_THRIFT);
    }

    @RequestMapping(value={"/dependencies"}, method={RequestMethod.GET}, produces={"application/json"})
    public byte[] getDependencies(@RequestParam(value="endTs", required=true) long endTs, @RequestParam(value="lookback", required=false, defaultValue="86400000") long lookback) {
        return this.jsonCodec.writeDependencyLinks(this.spanStore.getDependencies(endTs, Long.valueOf(lookback)));
    }

    @RequestMapping(value={"/services"}, method={RequestMethod.GET})
    public List<String> getServiceNames() {
        return this.spanStore.getServiceNames();
    }

    @RequestMapping(value={"/spans"}, method={RequestMethod.GET})
    public List<String> getSpanNames(@RequestParam(value="serviceName", required=true) String serviceName) {
        return this.spanStore.getSpanNames(serviceName);
    }

    @RequestMapping(value={"/spans"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void uploadSpansJson(@RequestBody byte[] body) {
        List spans = this.jsonCodec.readSpans(body);
        if (spans == null) {
            throw new MalformedSpansException("application/json");
        }
        this.spanWriter.write(this.spanStore, spans);
    }

    @RequestMapping(value={"/spans"}, method={RequestMethod.POST}, consumes={"application/x-thrift"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void uploadSpansThrift(@RequestBody byte[] body) {
        List spans = this.thriftCodec.readSpans(body);
        if (spans == null) {
            throw new MalformedSpansException(APPLICATION_THRIFT);
        }
        this.spanWriter.write(this.spanStore, spans);
    }

    @RequestMapping(value={"/traces"}, method={RequestMethod.GET}, produces={"application/json"})
    public byte[] getTraces(@RequestParam(value="serviceName", required=true) String serviceName, @RequestParam(value="spanName", defaultValue="all") String spanName, @RequestParam(value="annotationQuery", required=false) String annotationQuery, @RequestParam(value="minDuration", required=false) Long minDuration, @RequestParam(value="maxDuration", required=false) Long maxDuration, @RequestParam(value="endTs", required=false) Long endTs, @RequestParam(value="lookback", required=false, defaultValue="86400000") long lookback, @RequestParam(value="limit", required=false) Integer limit) {
        QueryRequest.Builder builder = new QueryRequest.Builder(serviceName).spanName(spanName.equals("all") ? null : spanName).minDuration(minDuration).maxDuration(maxDuration).endTs(endTs).lookback(Long.valueOf(lookback)).limit(limit);
        if (annotationQuery != null && !annotationQuery.isEmpty()) {
            for (String ann : annotationQuery.split(" and ")) {
                if (ann.indexOf(61) == -1) {
                    builder.addAnnotation(ann);
                    continue;
                }
                String[] keyValue = ann.split("=");
                if (keyValue.length < 2 || keyValue[1] == null) {
                    builder.addAnnotation(ann);
                }
                builder.addBinaryAnnotation(keyValue[0], keyValue[1]);
            }
        }
        return this.jsonCodec.writeTraces(this.spanStore.getTraces(builder.build()));
    }

    @RequestMapping(value={"/trace/{traceId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public byte[] getTrace(@PathVariable String traceId) {
        long id = new Buffer().writeUtf8(traceId).readHexadecimalUnsignedLong();
        List traces = this.spanStore.getTracesByIds(Collections.singletonList(id));
        if (traces.isEmpty()) {
            throw new TraceNotFoundException(traceId, id);
        }
        return this.jsonCodec.writeSpans((List)traces.get(0));
    }

    @ExceptionHandler(value={TraceNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public void notFound() {
    }

    @ExceptionHandler(value={MalformedSpansException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public void malformedSpans() {
    }

    static class MalformedSpansException
    extends RuntimeException {
        public MalformedSpansException(String mediaType) {
            super("List of spans was malformed for media type " + mediaType);
        }
    }

    static class TraceNotFoundException
    extends RuntimeException {
        public TraceNotFoundException(String traceId, long id) {
            super("Cannot find trace for id=" + traceId + ", long value=" + id);
        }
    }
}

