/*
 * Decompiled with CFR 0.152.
 */
package io.zipkin.server.brave;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.LocalTracer;
import io.zipkin.DependencyLink;
import io.zipkin.QueryRequest;
import io.zipkin.Span;
import io.zipkin.SpanStore;
import io.zipkin.internal.Nullable;
import java.util.List;

public final class TraceWritesSpanStore
implements SpanStore {
    private final LocalTracer tracer;
    private final SpanStore delegate;
    private final String component;

    public TraceWritesSpanStore(Brave brave, SpanStore delegate) {
        this.tracer = brave.localTracer();
        this.delegate = delegate;
        this.component = delegate.getClass().getSimpleName();
    }

    public void accept(List<Span> spans) {
        this.delegate.accept(spans);
    }

    public List<List<Span>> getTraces(QueryRequest request) {
        if (this.tracer.startNewSpan(this.component, "get-traces") != null) {
            this.tracer.submitBinaryAnnotation("request", request.toString());
        }
        try {
            List list = this.delegate.getTraces(request);
            return list;
        }
        finally {
            this.tracer.finishSpan();
        }
    }

    public List<List<Span>> getTracesByIds(List<Long> traceIds) {
        this.tracer.startNewSpan(this.component, "get-traces-by-ids");
        try {
            List list = this.delegate.getTracesByIds(traceIds);
            return list;
        }
        finally {
            this.tracer.finishSpan();
        }
    }

    public List<String> getServiceNames() {
        this.tracer.startNewSpan(this.component, "get-service-names");
        try {
            List list = this.delegate.getServiceNames();
            return list;
        }
        finally {
            this.tracer.finishSpan();
        }
    }

    public List<String> getSpanNames(String serviceName) {
        this.tracer.startNewSpan(this.component, "get-span-names");
        try {
            List list = this.delegate.getSpanNames(serviceName);
            return list;
        }
        finally {
            this.tracer.finishSpan();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DependencyLink> getDependencies(long endTs, @Nullable Long lookback) {
        this.tracer.startNewSpan(this.component, "get-dependencies");
        try {
            List list = this.delegate.getDependencies(endTs, lookback);
            return list;
        }
        finally {
            this.tracer.finishSpan();
        }
    }

    public void close() {
        this.delegate.close();
    }
}

