/*
 * Decompiled with CFR 0.152.
 */
package io.zipkin.server;

import com.github.kristofa.brave.Brave;
import io.zipkin.Codec;
import io.zipkin.SpanStore;
import io.zipkin.TraceIdSampler;
import io.zipkin.jdbc.JDBCSpanStore;
import io.zipkin.server.InMemorySpanStore;
import io.zipkin.server.ZipkinServerProperties;
import io.zipkin.server.brave.TraceWritesSpanStore;
import javax.sql.DataSource;
import org.jooq.ExecuteListenerProvider;
import org.jooq.conf.Settings;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@EnableConfigurationProperties(value={ZipkinServerProperties.class})
@EnableAsync(proxyTargetClass=true)
public class ZipkinServerConfiguration {
    @Autowired
    ZipkinServerProperties server;
    @Autowired(required=false)
    DataSource datasource;
    @Autowired(required=false)
    @Qualifier(value="jdbcTraceListenerProvider")
    ExecuteListenerProvider listener;

    @Bean
    @ConditionalOnMissingBean(value={Codec.Factory.class})
    Codec.Factory codecFactory() {
        return Codec.FACTORY;
    }

    @Bean
    @ConditionalOnMissingBean(value={TraceIdSampler.class})
    TraceIdSampler traceIdSampler(@Value(value="${zipkin.collector.sample-rate}") float rate) {
        return TraceIdSampler.create((float)rate);
    }

    @Bean
    SpanStore spanStore() {
        InMemorySpanStore result = this.datasource != null && this.server.getStore().getType() == ZipkinServerProperties.Store.Type.mysql ? new JDBCSpanStore(this.datasource, new Settings().withRenderSchema(Boolean.valueOf(false)), this.listener) : new InMemorySpanStore();
        return result;
    }

    @Configuration
    @ConditionalOnClass(value={Brave.class})
    protected static class BraveSpanStoreEnhancer
    implements BeanPostProcessor {
        @Autowired(required=false)
        Brave brave;

        protected BraveSpanStoreEnhancer() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof SpanStore && this.brave != null) {
                return new TraceWritesSpanStore(this.brave, (SpanStore)bean);
            }
            return bean;
        }
    }
}

