/*
 * Decompiled with CFR 0.152.
 */
package io.zipkin.server.brave;

import com.github.kristofa.brave.Brave;
import io.zipkin.Endpoint;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;
import org.jooq.ExecuteType;
import org.jooq.impl.DefaultExecuteListener;
import org.jooq.impl.DefaultExecuteListenerProvider;
import org.jooq.tools.StringUtils;
import org.mariadb.jdbc.Driver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnClass(value={Driver.class})
@Configuration
public class JDBCTracerConfiguration
extends DefaultExecuteListener {
    @Autowired
    Brave brave;
    @Autowired
    @Qualifier(value="jdbc")
    Endpoint jdbcEndpoint;

    @Bean
    ExecuteListenerProvider jdbcTraceListenerProvider() {
        return new DefaultExecuteListenerProvider((ExecuteListener)this);
    }

    @Bean
    @Qualifier(value="jdbc")
    Endpoint jdbc(@Value(value="${spring.datasource.url}") String jdbcUrl) throws UnknownHostException {
        URI url = URI.create(jdbcUrl.substring(5));
        int ipv4 = ByteBuffer.wrap(InetAddress.getByName(url.getHost()).getAddress()).getInt();
        return Endpoint.create((String)"zipkin-jdbc", (int)ipv4, (int)url.getPort());
    }

    public void renderEnd(ExecuteContext ctx) {
        if (ctx.type() == ExecuteType.READ) {
            this.brave.clientTracer().startNewSpan("query");
            this.brave.clientTracer().setCurrentClientServiceName("zipkin-query");
            Object[] batchSQL = ctx.batchSQL();
            if (!StringUtils.isBlank((String)ctx.sql())) {
                this.brave.clientTracer().submitBinaryAnnotation("jdbc.query", ctx.sql());
            } else if (batchSQL.length > 0 && batchSQL[batchSQL.length - 1] != null) {
                this.brave.clientTracer().submitBinaryAnnotation("jdbc.query", StringUtils.join((Object[])batchSQL, (char)'\n'));
            }
            this.brave.clientTracer().setClientSent(this.jdbcEndpoint.ipv4, (int)this.jdbcEndpoint.port.shortValue(), this.jdbcEndpoint.serviceName);
        }
    }

    public void executeEnd(ExecuteContext ctx) {
        if (ctx.type() == ExecuteType.READ) {
            this.brave.clientTracer().setClientReceived();
        }
    }
}

